/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.ActivityImpl;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StartUpMeasurer {
    public static final long MEASURE_THRESHOLD = TimeUnit.MILLISECONDS.toNanos(10L);
    public static boolean measuringPluginStartupCosts = true;
    private static long startTime = System.nanoTime();
    private static long startTimeUnixNanoDiff = System.currentTimeMillis() * 1000000L - startTime;
    private static final ConcurrentLinkedQueue<ActivityImpl> items = new ConcurrentLinkedQueue();
    private static boolean isEnabled = true;
    @ApiStatus.Internal
    public static final Map<String, Object2LongOpenHashMap<String>> pluginCostMap = new ConcurrentHashMap<String, Object2LongOpenHashMap<String>>();

    @ApiStatus.Internal
    public static long getStartTime() {
        return startTime;
    }

    @NotNull
    public static Activity startActivity(@NonNls @NotNull String name) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(3);
        }
        return new ActivityImpl(name, System.nanoTime(), null, null, ActivityCategory.DEFAULT);
    }

    /*
     * WARNING - void declaration
     */
    public static long addCompletedActivity(long start, @NotNull Class<?> clazz, @NotNull ActivityCategory category, @Nullable String pluginId, long l) {
        void threshold;
        if (clazz == null) {
            StartUpMeasurer.$$$reportNull$$$0(8);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(9);
        }
        if (!isEnabled) {
            return -1L;
        }
        long end = System.nanoTime();
        long duration = end - start;
        if (duration <= threshold) {
            return duration;
        }
        StartUpMeasurer.addCompletedActivity(start, end, clazz.getName(), category, pluginId);
        return duration;
    }

    /*
     * WARNING - void declaration
     */
    public static void addCompletedActivity(long start, long end, @NonNls @NotNull String name, @NotNull ActivityCategory activityCategory, String string2) {
        void category;
        void pluginId;
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(12);
        }
        if (activityCategory == null) {
            StartUpMeasurer.$$$reportNull$$$0(13);
        }
        if (!isEnabled) {
            return;
        }
        ActivityImpl item = new ActivityImpl(name, start, null, (String)pluginId, (ActivityCategory)category);
        item.setEnd(end);
        items.add(item);
    }

    public static void addActivity(@NotNull ActivityImpl activity) {
        if (activity == null) {
            StartUpMeasurer.$$$reportNull$$$0(15);
        }
        if (isEnabled) {
            items.add(activity);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginCostMap";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/StartUpMeasurer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addInstantEvent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "startActivity";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletedActivity";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "processAndClear";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "addActivity";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "addPluginCost";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "doAddPluginCost";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

