/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionDescriptor;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.AdapterWithCustomAttributes;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.InterfaceExtensionImplementationClassResolver;
import com.intellij.openapi.extensions.impl.SimpleConstructorInjectionAdapter;
import com.intellij.util.xml.dom.XmlElement;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BE\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J8\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00190\u00182\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00190\u0018H\u0014R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/extensions/impl/InterfaceExtensionPoint;", "T", "", "Lcom/intellij/openapi/extensions/impl/ExtensionPointImpl;", "name", "", "className", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "clazz", "Ljava/lang/Class;", "dynamic", "", "hasAttributes", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/extensions/PluginDescriptor;Lcom/intellij/openapi/components/ComponentManager;Ljava/lang/Class;ZZ)V", "createAdapter", "Lcom/intellij/openapi/extensions/impl/ExtensionComponentAdapter;", "descriptor", "Lcom/intellij/openapi/extensions/ExtensionDescriptor;", "unregisterExtensions", "", "priorityListenerCallbacks", "", "Ljava/lang/Runnable;", "listenerCallbacks", "intellij.platform.extensions"})
public final class InterfaceExtensionPoint<T>
extends ExtensionPointImpl<T> {
    private final boolean hasAttributes;

    public InterfaceExtensionPoint(@NotNull String name, @NotNull String className, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager, @Nullable Class<T> clazz, boolean dynamic, boolean hasAttributes) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(className, "className");
        Intrinsics.checkNotNullParameter(pluginDescriptor, "pluginDescriptor");
        Intrinsics.checkNotNullParameter(componentManager, "componentManager");
        super(name, className, pluginDescriptor, componentManager, clazz, dynamic);
        this.hasAttributes = hasAttributes;
    }

    @Override
    @NotNull
    public ExtensionComponentAdapter createAdapter(@NotNull ExtensionDescriptor descriptor2, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(pluginDescriptor, "pluginDescriptor");
        Intrinsics.checkNotNullParameter(componentManager, "componentManager");
        String string2 = descriptor2.implementation;
        if (string2 == null) {
            RuntimeException runtimeException = componentManager.createError("Attribute \"implementation\" is not specified for \"" + this.getName() + "\" extension", pluginDescriptor.getPluginId());
            Intrinsics.checkNotNullExpressionValue(runtimeException, "createError(...)");
            throw (Throwable)runtimeException;
        }
        String implementationClassName = string2;
        if (this.hasAttributes) {
            Object object;
            if (descriptor2.hasExtraAttributes) {
                object = descriptor2.element;
                if (object == null || (object = ((XmlElement)object).attributes) == null) {
                    object = MapsKt.emptyMap();
                }
            } else {
                object = MapsKt.emptyMap();
            }
            Map<String, String> customAttributes = object;
            descriptor2.element = null;
            InterfaceExtensionImplementationClassResolver interfaceExtensionImplementationClassResolver = InterfaceExtensionImplementationClassResolver.INSTANCE;
            return new AdapterWithCustomAttributes(implementationClassName, pluginDescriptor, descriptor2, interfaceExtensionImplementationClassResolver, customAttributes);
        }
        if (!descriptor2.hasExtraAttributes && descriptor2.element != null) {
            XmlElement xmlElement = descriptor2.element;
            Intrinsics.checkNotNull(xmlElement);
            if (xmlElement.children.isEmpty()) {
                descriptor2.element = null;
            }
        }
        return new SimpleConstructorInjectionAdapter(implementationClassName, pluginDescriptor, descriptor2, InterfaceExtensionImplementationClassResolver.INSTANCE);
    }
}

