/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionDescriptor;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ImplementationClassResolver;
import com.intellij.openapi.extensions.impl.XmlExtensionAdapter;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ)\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/extensions/impl/SimpleConstructorInjectionAdapter;", "Lcom/intellij/openapi/extensions/impl/XmlExtensionAdapter;", "implementationClassName", "", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "descriptor", "Lcom/intellij/openapi/extensions/ExtensionDescriptor;", "implementationClassResolver", "Lcom/intellij/openapi/extensions/impl/ImplementationClassResolver;", "(Ljava/lang/String;Lcom/intellij/openapi/extensions/PluginDescriptor;Lcom/intellij/openapi/extensions/ExtensionDescriptor;Lcom/intellij/openapi/extensions/impl/ImplementationClassResolver;)V", "instantiateClass", "T", "aClass", "Ljava/lang/Class;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "(Ljava/lang/Class;Lcom/intellij/openapi/components/ComponentManager;)Ljava/lang/Object;", "intellij.platform.extensions"})
public final class SimpleConstructorInjectionAdapter
extends XmlExtensionAdapter {
    public SimpleConstructorInjectionAdapter(@NotNull String implementationClassName, @NotNull PluginDescriptor pluginDescriptor, @NotNull ExtensionDescriptor descriptor2, @NotNull ImplementationClassResolver implementationClassResolver) {
        Intrinsics.checkNotNullParameter(implementationClassName, "implementationClassName");
        Intrinsics.checkNotNullParameter(pluginDescriptor, "pluginDescriptor");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(implementationClassResolver, "implementationClassResolver");
        super(implementationClassName, pluginDescriptor, descriptor2.orderId, descriptor2.order, descriptor2.element, implementationClassResolver);
    }

    @Override
    protected <T> T instantiateClass(@NotNull Class<T> aClass, @NotNull ComponentManager componentManager) {
        Intrinsics.checkNotNullParameter(aClass, "aClass");
        Intrinsics.checkNotNullParameter(componentManager, "componentManager");
        if (!Intrinsics.areEqual(aClass.getName(), "org.jetbrains.kotlin.asJava.finder.JavaElementFinder")) {
            try {
                return super.instantiateClass(aClass, componentManager);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (ExtensionNotApplicableException e) {
                throw e;
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof NoSuchMethodException) && !(cause instanceof IllegalArgumentException)) {
                    throw e;
                }
                StringBuilder stringBuilder = new StringBuilder().append("Cannot create extension without pico container (class=").append(aClass.getName()).append(", constructors=");
                String string2 = Arrays.toString(aClass.getDeclaredConstructors());
                Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                ExtensionPointImpl.LOG.error(stringBuilder.append(string2).append("), please remove extra constructor parameters").toString(), e);
            }
        }
        return componentManager.instantiateClassWithConstructorInjection(aClass, aClass, this.pluginDescriptor.getPluginId());
    }
}

