/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.light.LightElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightParameterListBuilder
extends LightElement
implements PsiParameterList {
    private final List<PsiParameter> myParameters = new ArrayList<PsiParameter>();
    private PsiParameter[] myCachedParameters;

    public LightParameterListBuilder(PsiManager manager, Language language) {
        super(manager, language);
    }

    public void addParameter(PsiParameter parameter) {
        this.myParameters.add(parameter);
        this.myCachedParameters = null;
    }

    @Override
    public String toString() {
        return "Light parameter list";
    }

    @Override
    public PsiParameter @NotNull [] getParameters() {
        if (this.myCachedParameters == null) {
            this.myCachedParameters = this.myParameters.isEmpty() ? PsiParameter.EMPTY_ARRAY : this.myParameters.toArray(PsiParameter.EMPTY_ARRAY);
        }
        if (this.myCachedParameters == null) {
            LightParameterListBuilder.$$$reportNull$$$0(0);
        }
        return this.myCachedParameters;
    }

    @Override
    @Nullable
    public PsiParameter getParameter(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index is negative: " + index);
        }
        if (index < this.myParameters.size()) {
            return this.myParameters.get(index);
        }
        return null;
    }

    @Override
    public int getParameterIndex(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            LightParameterListBuilder.$$$reportNull$$$0(1);
        }
        return this.myParameters.indexOf(parameter);
    }

    @Override
    public int getParametersCount() {
        return this.myParameters.size();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            LightParameterListBuilder.$$$reportNull$$$0(2);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitParameterList(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String getText() {
        return this.myParameters.stream().map(parameter -> parameter.getText()).filter(Objects::nonNull).collect(Collectors.joining(",", "(", ")"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/light/LightParameterListBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/light/LightParameterListBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getParameterIndex";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

