/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.session;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaAnalysisApiInternals;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H&J8\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H\u00130\u0015\u00a2\u0006\u0002\b\u0016H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J8\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H\u00130\u0015\u00a2\u0006\u0002\b\u0016H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH'J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H'J\u0018\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH'J\u0018\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H'J\b\u0010\u001d\u001a\u00020\u001aH&J\b\u0010\u001e\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/analysis/api/session/KaSessionProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "tokenFactory", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeTokenFactory;", "getTokenFactory", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeTokenFactory;", "getAnalysisSession", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "useSiteElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "useSiteModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "analyze", "R", "action", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "beforeEnteringAnalysis", "", "session", "afterLeavingAnalysis", "clearCaches", "dispose", "Companion", "analysis-api"})
public abstract class KaSessionProvider
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public KaSessionProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public abstract KaLifetimeTokenFactory getTokenFactory();

    @NotNull
    public abstract KaSession getAnalysisSession(@NotNull KtElement var1);

    @NotNull
    public abstract KaSession getAnalysisSession(@NotNull KaModule var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R analyze(@NotNull KtElement useSiteElement, @NotNull Function1<? super KaSession, ? extends R> action) {
        R r;
        Intrinsics.checkNotNullParameter(useSiteElement, "useSiteElement");
        Intrinsics.checkNotNullParameter(action, "action");
        boolean $i$f$analyze = false;
        KaSession analysisSession = this.getAnalysisSession(useSiteElement);
        this.beforeEnteringAnalysis(analysisSession, useSiteElement);
        try {
            r = action.invoke(analysisSession);
        }
        finally {
            InlineMarker.finallyStart(1);
            this.afterLeavingAnalysis(analysisSession, useSiteElement);
            InlineMarker.finallyEnd(1);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R analyze(@NotNull KaModule useSiteModule, @NotNull Function1<? super KaSession, ? extends R> action) {
        R r;
        Intrinsics.checkNotNullParameter(useSiteModule, "useSiteModule");
        Intrinsics.checkNotNullParameter(action, "action");
        boolean $i$f$analyze = false;
        KaSession analysisSession = this.getAnalysisSession(useSiteModule);
        this.beforeEnteringAnalysis(analysisSession, useSiteModule);
        try {
            r = action.invoke(analysisSession);
        }
        finally {
            InlineMarker.finallyStart(1);
            this.afterLeavingAnalysis(analysisSession, useSiteModule);
            InlineMarker.finallyEnd(1);
        }
        return r;
    }

    @KaAnalysisApiInternals
    public abstract void beforeEnteringAnalysis(@NotNull KaSession var1, @NotNull KtElement var2);

    @KaAnalysisApiInternals
    public abstract void beforeEnteringAnalysis(@NotNull KaSession var1, @NotNull KaModule var2);

    @KaAnalysisApiInternals
    public abstract void afterLeavingAnalysis(@NotNull KaSession var1, @NotNull KtElement var2);

    @KaAnalysisApiInternals
    public abstract void afterLeavingAnalysis(@NotNull KaSession var1, @NotNull KaModule var2);

    public abstract void clearCaches();

    @Override
    public void dispose() {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/session/KaSessionProvider$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/analysis/api/session/KaSessionProvider;", "project", "Lcom/intellij/openapi/project/Project;", "analysis-api"})
    public static final class Companion {
        private Companion() {
        }

        @KaAnalysisApiInternals
        @NotNull
        public final KaSessionProvider getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter(project, "project");
            KaSessionProvider kaSessionProvider = project.getService(KaSessionProvider.class);
            Intrinsics.checkNotNullExpressionValue(kaSessionProvider, "getService(...)");
            return kaSessionProvider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

