/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.symbols.pointers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaImplementationDetail;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolOrigin;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KaAnnotatedSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.pointers.KaSymbolPointer;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@KaImplementationDetail
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u0014*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0014B'\b\u0002\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nB\u001f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\fJ\u0017\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0017\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaPsiBasedSymbolPointer;", "S", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer;", "psiPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtElement;", "expectedClass", "Lkotlin/reflect/KClass;", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;Lkotlin/reflect/KClass;)V", "psi", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/reflect/KClass;)V", "restoreSymbol", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "pointsToTheSameSymbolAs", "", "other", "Companion", "analysis-api"})
public final class KaPsiBasedSymbolPointer<S extends KaSymbol>
extends KaSymbolPointer<S> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SmartPsiElementPointer<? extends KtElement> psiPointer;
    @NotNull
    private final KClass<S> expectedClass;
    @NotNull
    private static final ThreadLocal<Boolean> disablePsiPointerFlag;
    private static volatile boolean disablePsiPointer;

    private KaPsiBasedSymbolPointer(SmartPsiElementPointer<? extends KtElement> psiPointer, KClass<S> expectedClass) {
        this.psiPointer = psiPointer;
        this.expectedClass = expectedClass;
    }

    @Override
    @KaImplementationDetail
    @Nullable
    public S restoreSymbol(@NotNull KaSession analysisSession) {
        KaAnnotatedSymbol kaAnnotatedSymbol;
        Intrinsics.checkNotNullParameter(analysisSession, "analysisSession");
        KtElement ktElement = this.psiPointer.getElement();
        if (ktElement == null) {
            return null;
        }
        KtElement psi = ktElement;
        KaSession $this$restoreSymbol_u24lambda_u240 = analysisSession;
        boolean bl = false;
        if (!$this$restoreSymbol_u24lambda_u240.canBeAnalysed(psi)) {
            return null;
        }
        KtElement ktElement2 = psi;
        if (ktElement2 instanceof KtDeclaration) {
            kaAnnotatedSymbol = $this$restoreSymbol_u24lambda_u240.getSymbol((KtDeclaration)psi);
        } else if (ktElement2 instanceof KtFile) {
            kaAnnotatedSymbol = $this$restoreSymbol_u24lambda_u240.getSymbol((KtFile)psi);
        } else {
            throw new IllegalStateException(("Unexpected declaration to restore: " + Reflection.getOrCreateKotlinClass(psi.getClass()) + ", text:\n " + psi.getText()).toString());
        }
        KaSymbol symbol = kaAnnotatedSymbol;
        if (!this.expectedClass.isInstance(symbol)) {
            return null;
        }
        Intrinsics.checkNotNull(symbol, "null cannot be cast to non-null type S of org.jetbrains.kotlin.analysis.api.symbols.pointers.KaPsiBasedSymbolPointer");
        return (S)symbol;
    }

    @Override
    public boolean pointsToTheSameSymbolAs(@NotNull KaSymbolPointer<? extends KaSymbol> other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this == other || other instanceof KaPsiBasedSymbolPointer && Intrinsics.areEqual(((KaPsiBasedSymbolPointer)other).expectedClass, this.expectedClass) && Intrinsics.areEqual(((KaPsiBasedSymbolPointer)other).psiPointer, this.psiPointer);
    }

    public KaPsiBasedSymbolPointer(@NotNull KtElement psi, @NotNull KClass<S> expectedClass) {
        Intrinsics.checkNotNullParameter(psi, "psi");
        Intrinsics.checkNotNullParameter(expectedClass, "expectedClass");
        this(PsiUtilsKt.createSmartPointer((PsiElement)psi), expectedClass);
    }

    private static final Boolean disablePsiPointerFlag$lambda$1() {
        return false;
    }

    static {
        ThreadLocal<Boolean> threadLocal = ThreadLocal.withInitial(KaPsiBasedSymbolPointer::disablePsiPointerFlag$lambda$1);
        Intrinsics.checkNotNullExpressionValue(threadLocal, "withInitial(...)");
        disablePsiPointerFlag = threadLocal;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u0005\"\n\b\u0001\u0010\u0006\u0018\u0001*\u00020\u00072\u000b\u0010\b\u001a\u0007H\u0006\u00a2\u0006\u0002\b\tH\u0086\b\u00a2\u0006\u0002\u0010\nJ3\u0010\u0004\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u0002H\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\f\u00a2\u0006\u0002\u0010\rJ.\u0010\u000e\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\fJ%\u0010\u000e\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u0005\"\n\b\u0001\u0010\u0006\u0018\u0001*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\bJ'\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0001\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016\u00a2\u0006\u0002\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00192\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0082\bR\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaPsiBasedSymbolPointer$Companion;", "", "<init>", "()V", "createForSymbolFromSource", "Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaPsiBasedSymbolPointer;", "S", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "symbol", "Lkotlin/internal/NoInfer;", "(Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;)Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaPsiBasedSymbolPointer;", "expectedClass", "Lkotlin/reflect/KClass;", "(Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;Lkotlin/reflect/KClass;)Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaPsiBasedSymbolPointer;", "createForSymbolFromPsi", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "withDisabledPsiBasedPointers", "T", "disable", "", "action", "Lkotlin/Function0;", "(ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "ifDisabled", "", "disablePsiPointerFlag", "Ljava/lang/ThreadLocal;", "disablePsiPointer", "analysis-api"})
    @SourceDebugExtension(value={"SMAP\nKaPsiBasedSymbolPointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaPsiBasedSymbolPointer.kt\norg/jetbrains/kotlin/analysis/api/symbols/pointers/KaPsiBasedSymbolPointer$Companion\n*L\n1#1,117:1\n93#1,5:118\n93#1,5:123\n*S KotlinDebug\n*F\n+ 1 KaPsiBasedSymbolPointer.kt\norg/jetbrains/kotlin/analysis/api/symbols/pointers/KaPsiBasedSymbolPointer$Companion\n*L\n58#1:118,5\n74#1:123,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ <S extends KaSymbol> KaPsiBasedSymbolPointer<S> createForSymbolFromSource(S symbol) {
            Intrinsics.checkNotNullParameter(symbol, "symbol");
            boolean $i$f$createForSymbolFromSource = false;
            Intrinsics.reifiedOperationMarker(4, "S");
            return this.createForSymbolFromSource(symbol, Reflection.getOrCreateKotlinClass(KaSymbol.class));
        }

        @Nullable
        public final <S extends KaSymbol> KaPsiBasedSymbolPointer<S> createForSymbolFromSource(@NotNull S symbol, @NotNull KClass<S> expectedClass) {
            KtAnnotated ktAnnotated;
            Intrinsics.checkNotNullParameter(symbol, "symbol");
            Intrinsics.checkNotNullParameter(expectedClass, "expectedClass");
            Companion this_$iv = this;
            boolean $i$f$ifDisabled = false;
            if (disablePsiPointer && ((Boolean)disablePsiPointerFlag.get()).booleanValue()) {
                boolean bl = false;
                return null;
            }
            if (symbol.getOrigin() != KaSymbolOrigin.SOURCE) {
                return null;
            }
            PsiElement psi = symbol.getPsi();
            if (psi instanceof KtDeclaration) {
                ktAnnotated = (KtAnnotated)psi;
            } else if (psi instanceof KtFile) {
                ktAnnotated = (KtAnnotated)psi;
            } else if (psi instanceof KtObjectLiteralExpression) {
                KtObjectDeclaration ktObjectDeclaration = ((KtObjectLiteralExpression)psi).getObjectDeclaration();
                Intrinsics.checkNotNullExpressionValue(ktObjectDeclaration, "getObjectDeclaration(...)");
                ktAnnotated = ktObjectDeclaration;
            } else {
                return null;
            }
            KtAnnotated psi2 = ktAnnotated;
            return new KaPsiBasedSymbolPointer<S>(psi2, expectedClass);
        }

        @Nullable
        public final <S extends KaSymbol> KaPsiBasedSymbolPointer<S> createForSymbolFromPsi(@NotNull KtElement ktElement, @NotNull KClass<S> expectedClass) {
            Intrinsics.checkNotNullParameter(ktElement, "ktElement");
            Intrinsics.checkNotNullParameter(expectedClass, "expectedClass");
            Companion this_$iv = this;
            boolean $i$f$ifDisabled = false;
            if (disablePsiPointer && ((Boolean)disablePsiPointerFlag.get()).booleanValue()) {
                boolean bl = false;
                return null;
            }
            return new KaPsiBasedSymbolPointer<S>(ktElement, expectedClass);
        }

        public final /* synthetic */ <S extends KaSymbol> KaPsiBasedSymbolPointer<S> createForSymbolFromPsi(KtElement ktElement) {
            Intrinsics.checkNotNullParameter(ktElement, "ktElement");
            boolean $i$f$createForSymbolFromPsi = false;
            Intrinsics.reifiedOperationMarker(4, "S");
            return this.createForSymbolFromPsi(ktElement, Reflection.getOrCreateKotlinClass(KaSymbol.class));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T withDisabledPsiBasedPointers(boolean disable, @NotNull Function0<? extends T> action) {
            T t;
            Intrinsics.checkNotNullParameter(action, "action");
            try {
                disablePsiPointer = true;
                disablePsiPointerFlag.set(disable);
                t = action.invoke();
            }
            finally {
                disablePsiPointerFlag.remove();
            }
            return t;
        }

        private final void ifDisabled(Function0<Unit> action) {
            boolean $i$f$ifDisabled = false;
            if (!disablePsiPointer) {
                return;
            }
            if (((Boolean)disablePsiPointerFlag.get()).booleanValue()) {
                action.invoke();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

