/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DuplicateIrNodeError;
import org.jetbrains.kotlin.backend.common.IrValidatorConfig;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012:\u0010\u0004\u001a6\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005j\u0002`\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u001c\u0010\u001c\u001a\u00020\f*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\f\u0010!\u001a\u00020\f*\u00020\u001dH\u0002J\u0014\u0010\"\u001a\u00020\f*\u00020\u001d2\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0014\u0010#\u001a\u00020\f*\u00020$2\u0006\u0010%\u001a\u00020\u001dH\u0002J\u0014\u0010&\u001a\u00020\f*\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0002J\u0014\u0010)\u001a\u00020\f2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030*H\u0016J\u0010\u0010+\u001a\u00020\f2\u0006\u0010%\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\f2\u0006\u0010%\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\f2\u0006\u0010%\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\f2\u0006\u0010%\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\f2\u0006\u0010%\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\f2\u0006\u0010%\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\f2\u0006\u0010%\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\f2\u0006\u0010%\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\f2\u0006\u0010%\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\f2\u0006\u0010%\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\f2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\f2\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020\f2\u0006\u0010%\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020\f2\u0006\u0010%\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020\f2\u0006\u0010J\u001a\u00020(H\u0016J\u0010\u0010K\u001a\u00020\f2\u0006\u0010%\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020\f2\u0006\u0010J\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020\f2\u0006\u0010%\u001a\u00020PH\u0016J\u0010\u0010Q\u001a\u00020\f2\u0006\u0010%\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020\f2\u0006\u0010%\u001a\u00020TH\u0016J\u0010\u0010U\u001a\u00020\f2\u0006\u0010%\u001a\u00020VH\u0016J\u0010\u0010W\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u001dH\u0016J\u0018\u0010X\u001a\u00020\f2\u0006\u0010Y\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\u0006H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013RE\u0010\u0004\u001a6\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005j\u0002`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0019j\b\u0012\u0004\u0012\u00020\u0006`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lorg/jetbrains/kotlin/backend/common/CheckIrElementVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "reportError", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lkotlin/ParameterName;", "name", "element", "", "message", "", "Lorg/jetbrains/kotlin/backend/common/ReportError;", "config", "Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lkotlin/jvm/functions/Function2;Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;)V", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getReportError", "()Lkotlin/jvm/functions/Function2;", "getConfig", "()Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;", "visitedElements", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "visitElement", "ensureTypesEqual", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "actualType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "expectedType", "ensureNullable", "ensureTypeIs", "ensureBound", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "expression", "checkFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitInstanceInitializerCall", "Lorg/jetbrains/kotlin/ir/expressions/IrInstanceInitializerCall;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "visitBreakContinue", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreakContinue;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitFunction", "declaration", "visitDeclarationReference", "Lorg/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "visitLocalDelegatedPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrLocalDelegatedPropertyReference;", "visitExpression", "checkType", "type", "ir.backend.common"})
public final class CheckIrElementVisitor
implements IrElementVisitorVoid {
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Function2<IrElement, String, Unit> reportError;
    @NotNull
    private final IrValidatorConfig config;
    @NotNull
    private final HashSet<IrElement> visitedElements;

    public CheckIrElementVisitor(@NotNull IrBuiltIns irBuiltIns, @NotNull Function2<? super IrElement, ? super String, Unit> reportError, @NotNull IrValidatorConfig config) {
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        Intrinsics.checkNotNullParameter(reportError, "reportError");
        Intrinsics.checkNotNullParameter(config, "config");
        this.irBuiltIns = irBuiltIns;
        this.reportError = reportError;
        this.config = config;
        this.visitedElements = new HashSet();
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @NotNull
    public final Function2<IrElement, String, Unit> getReportError() {
        return this.reportError;
    }

    @NotNull
    public final IrValidatorConfig getConfig() {
        return this.config;
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        if (!this.visitedElements.add(element)) {
            String renderString = element instanceof IrTypeParameter ? RenderIrElementKt.render$default(element, null, 1, null) + " of " + RenderIrElementKt.render$default(((IrTypeParameter)element).getParent(), null, 1, null) : RenderIrElementKt.render$default(element, null, 1, null);
            this.reportError.invoke(element, "Duplicate IR node: " + renderString);
            throw new DuplicateIrNodeError(element);
        }
    }

    private final void ensureTypesEqual(IrExpression $this$ensureTypesEqual, IrType actualType, IrType expectedType) {
        if (!this.config.getCheckTypes()) {
            return;
        }
        if (!Intrinsics.areEqual(actualType, expectedType)) {
            this.reportError.invoke($this$ensureTypesEqual, "unexpected type: expected " + RenderIrElementKt.render$default(expectedType, null, 1, null) + ", got " + RenderIrElementKt.render$default(actualType, null, 1, null));
        }
    }

    private final void ensureNullable(IrExpression $this$ensureNullable) {
        if (!this.config.getCheckTypes()) {
            return;
        }
        if (!IrTypeUtilsKt.isNullable($this$ensureNullable.getType())) {
            this.reportError.invoke($this$ensureNullable, "expected a nullable type, got " + RenderIrElementKt.render$default($this$ensureNullable.getType(), null, 1, null));
        }
    }

    private final void ensureTypeIs(IrExpression $this$ensureTypeIs, IrType expectedType) {
        this.ensureTypesEqual($this$ensureTypeIs, $this$ensureTypeIs.getType(), expectedType);
    }

    private final void ensureBound(IrSymbol $this$ensureBound, IrExpression expression2) {
        if (!$this$ensureBound.isBound() && !(expression2.getType() instanceof IrDynamicType)) {
            this.reportError.invoke(expression2, "Unbound symbol " + $this$ensureBound);
        }
    }

    private final void checkFunction(IrElement $this$checkFunction, IrFunction function2) {
        if (function2 instanceof IrSimpleFunction && this.config.getCheckProperties()) {
            IrProperty property;
            IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)function2).getCorrespondingPropertySymbol();
            IrProperty irProperty = property = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            if (property != null && !Intrinsics.areEqual(property.getGetter(), function2) && !Intrinsics.areEqual(property.getSetter(), function2)) {
                this.reportError.invoke($this$checkFunction, "Orphaned property getter/setter " + RenderIrElementKt.render$default(function2, null, 1, null));
            }
        }
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        if ((irValueParameter != null ? irValueParameter.getType() : null) instanceof IrDynamicType) {
            this.reportError.invoke($this$checkFunction, "Dispatch receivers with 'dynamic' type are not allowed");
        }
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression2) {
        IrType irType;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
        IrConstKind<?> irConstKind = expression2.getKind();
        if (Intrinsics.areEqual(irConstKind, IrConstKind.Null.INSTANCE)) {
            this.ensureNullable(expression2);
            return;
        }
        if (Intrinsics.areEqual(irConstKind, IrConstKind.Boolean.INSTANCE)) {
            irType = this.irBuiltIns.getBooleanType();
        } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Char.INSTANCE)) {
            irType = this.irBuiltIns.getCharType();
        } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Byte.INSTANCE)) {
            irType = this.irBuiltIns.getByteType();
        } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Short.INSTANCE)) {
            irType = this.irBuiltIns.getShortType();
        } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Int.INSTANCE)) {
            irType = this.irBuiltIns.getIntType();
        } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Long.INSTANCE)) {
            irType = this.irBuiltIns.getLongType();
        } else if (Intrinsics.areEqual(irConstKind, IrConstKind.String.INSTANCE)) {
            irType = this.irBuiltIns.getStringType();
        } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Float.INSTANCE)) {
            irType = this.irBuiltIns.getFloatType();
        } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Double.INSTANCE)) {
            irType = this.irBuiltIns.getDoubleType();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        IrType naturalType = irType;
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
        this.ensureTypeIs(expression2, this.irBuiltIns.getStringType());
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
        this.ensureTypeIs(expression2, IrTypesKt.createType(expression2.getSymbol(), false, CollectionsKt.emptyList()));
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
        this.ensureTypeIs(expression2, expression2.getSymbol().getOwner().getType());
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
        IrValueDeclaration declaration = expression2.getSymbol().getOwner();
        if (declaration instanceof IrValueParameter && !((IrValueParameter)declaration).isAssignable()) {
            this.reportError.invoke(expression2, "Assignment to value parameters not marked assignable");
        }
        this.ensureTypeIs(expression2, this.irBuiltIns.getUnitType());
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
        IrType fieldType = ((IrField)expression2.getSymbol().getOwner()).getType();
        if (fieldType instanceof IrSimpleType && ((IrSimpleType)fieldType).getClassifier() instanceof IrClassSymbol && ((IrSimpleType)fieldType).getArguments().isEmpty()) {
            this.ensureTypeIs(expression2, fieldType);
        }
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
        this.ensureTypeIs(expression2, this.irBuiltIns.getUnitType());
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        block1: {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            IrSimpleFunction function2 = (IrSimpleFunction)expression2.getSymbol().getOwner();
            this.checkFunction(expression2, function2);
            IrType returnType = ((IrSimpleFunction)expression2.getSymbol().getOwner()).getReturnType();
            if (returnType instanceof IrSimpleType && ((IrSimpleType)returnType).getClassifier() instanceof IrClassSymbol && ((IrSimpleType)returnType).getArguments().isEmpty()) {
                this.ensureTypeIs(expression2, returnType);
            }
            IrClassSymbol irClassSymbol = expression2.getSuperQualifierSymbol();
            if (irClassSymbol == null) break block1;
            this.ensureBound(irClassSymbol, expression2);
        }
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
        this.ensureTypeIs(expression2, this.irBuiltIns.getUnitType());
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
        this.ensureTypeIs(expression2, this.irBuiltIns.getUnitType());
        this.ensureBound(expression2.getClassSymbol(), expression2);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrType irType;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
        IrTypeOperator operator = expression2.getOperator();
        IrType typeOperand = expression2.getTypeOperand();
        switch (WhenMappings.$EnumSwitchMapping$0[operator.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                irType = typeOperand;
                break;
            }
            case 9: {
                irType = IrTypesKt.makeNullable(typeOperand);
                break;
            }
            case 10: 
            case 11: {
                irType = this.irBuiltIns.getBooleanType();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        IrType naturalType = irType;
        if (operator == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT && !IrTypePredicatesKt.isUnit(typeOperand)) {
            this.reportError.invoke(expression2, "typeOperand is " + RenderIrElementKt.render$default(typeOperand, null, 1, null));
        }
        this.ensureTypeIs(expression2, naturalType);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop) {
        Intrinsics.checkNotNullParameter(loop, "loop");
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop);
        this.ensureTypeIs(loop, this.irBuiltIns.getUnitType());
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        Intrinsics.checkNotNullParameter(jump, "jump");
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
        this.ensureTypeIs(jump, this.irBuiltIns.getNothingType());
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
        this.ensureTypeIs(expression2, this.irBuiltIns.getNothingType());
        this.ensureBound(expression2.getReturnTargetSymbol(), expression2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
        this.ensureTypeIs(expression2, this.irBuiltIns.getNothingType());
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration) {
        IrDeclarationBase p;
        int i;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
        this.checkFunction(declaration, declaration);
        Iterator iterator2 = ((Iterable)declaration.getValueParameters()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            i = n++;
            p = (IrValueParameter)iterator2.next();
            if (((IrValueParameter)p).getIndex() == i) continue;
            this.reportError.invoke(declaration, "Inconsistent index of value parameter " + ((IrValueParameter)p).getIndex() + " != " + i);
        }
        iterator2 = ((Iterable)declaration.getTypeParameters()).iterator();
        n = 0;
        while (iterator2.hasNext()) {
            i = n++;
            p = (IrTypeParameter)iterator2.next();
            if (((IrTypeParameter)p).getIndex() == i) continue;
            this.reportError.invoke(declaration, "Inconsistent index of type parameter " + ((IrTypeParameter)p).getIndex() + " != " + i);
        }
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
        if (expression2 instanceof IrFieldAccessExpression) {
            IrType receiverType;
            IrExpression irExpression = ((IrFieldAccessExpression)expression2).getReceiver();
            IrType irType = receiverType = irExpression != null ? irExpression.getType() : null;
            if (receiverType instanceof IrDynamicType) {
                return;
            }
        }
        this.ensureBound(expression2.getSymbol(), expression2);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
        if (declaration instanceof IrOverridableDeclaration) {
            for (IrSymbol overriddenSymbol : ((IrOverridableDeclaration)((Object)declaration)).getOverriddenSymbols()) {
                IrDeclarationWithVisibility overriddenDeclaration;
                IrSymbolOwner irSymbolOwner = overriddenSymbol.getOwner();
                IrDeclarationWithVisibility irDeclarationWithVisibility = irSymbolOwner instanceof IrDeclarationWithVisibility ? (IrDeclarationWithVisibility)irSymbolOwner : null;
                if (irDeclarationWithVisibility == null || !Intrinsics.areEqual((overriddenDeclaration = irDeclarationWithVisibility).getVisibility(), DescriptorVisibilities.PRIVATE)) continue;
                this.reportError.invoke(declaration, "Overrides private declaration " + overriddenDeclaration);
            }
        }
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
        this.ensureBound((IrSymbol)expression2.getSymbol(), expression2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
        this.checkFunction(expression2, ((IrFunctionSymbol)expression2.getSymbol()).getOwner());
        this.ensureBound((IrSymbol)expression2.getSymbol(), expression2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        block2: {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            IrFieldSymbol irFieldSymbol = expression2.getField();
            if (irFieldSymbol != null) {
                this.ensureBound(irFieldSymbol, expression2);
            }
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getGetter();
            if (irSimpleFunctionSymbol != null) {
                this.ensureBound(irSimpleFunctionSymbol, expression2);
            }
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = expression2.getSetter();
            if (irSimpleFunctionSymbol2 == null) break block2;
            this.ensureBound(irSimpleFunctionSymbol2, expression2);
        }
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        block0: {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            this.ensureBound(expression2.getDelegate(), expression2);
            this.ensureBound(expression2.getGetter(), expression2);
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getSetter();
            if (irSimpleFunctionSymbol == null) break block0;
            this.ensureBound(irSimpleFunctionSymbol, expression2);
        }
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.checkType(expression2.getType(), expression2);
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
    }

    private final void checkType(IrType type2, IrElement element) {
        if (type2 instanceof IrSimpleType && !((IrSimpleType)type2).getClassifier().isBound()) {
            this.reportError.invoke(element, "Type: " + RenderIrElementKt.render$default((IrSimpleType)type2, null, 1, null) + " has unbound classifier");
        }
    }

    @Override
    public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data2);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data2);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data2);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration) {
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data2);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data2);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data2);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data2);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
    }

    @Override
    public void visitField(@NotNull IrField declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data2);
    }

    @Override
    public void visitField(@NotNull IrField declaration) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data2);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data2);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data2);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data2);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data2);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data2);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data2);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data2);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
    }

    @Override
    public void visitReturnableBlock(@NotNull IrReturnableBlock expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2, data2);
    }

    @Override
    public void visitReturnableBlock(@NotNull IrReturnableBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2);
    }

    @Override
    public void visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data2);
    }

    @Override
    public void visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock) {
        IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data2);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data2);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data2);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop, data2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop, data2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop, data2);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.CAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_CAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_NOTNULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_INTEGER_COERCION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAM_CONVERSION.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_DYNAMIC_CAST.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.REINTERPRET_CAST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAFE_CAST.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.INSTANCEOF.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.NOT_INSTANCEOF.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

