/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.bridges;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.bridges.FunctionHandle;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.util.DeclarationUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00000\tH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0013\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/backend/common/bridges/DescriptorBasedFunctionHandle;", "Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "_overridden", "", "get_overridden", "()Ljava/util/List;", "_overridden$delegate", "Lkotlin/Lazy;", "createHandleForOverridden", "overridden", "isDeclaration", "", "()Z", "isAbstract", "mayBeUsedAsSuperImplementation", "getMayBeUsedAsSuperImplementation", "getOverridden", "hashCode", "", "equals", "other", "", "toString", "", "backend-common"})
@SourceDebugExtension(value={"SMAP\nimpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 impl.kt\norg/jetbrains/kotlin/backend/common/bridges/DescriptorBasedFunctionHandle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1557#2:87\n1628#2,3:88\n*S KotlinDebug\n*F\n+ 1 impl.kt\norg/jetbrains/kotlin/backend/common/bridges/DescriptorBasedFunctionHandle\n*L\n56#1:87\n56#1:88,3\n*E\n"})
public class DescriptorBasedFunctionHandle
implements FunctionHandle {
    @NotNull
    private final FunctionDescriptor descriptor;
    @NotNull
    private final Lazy _overridden$delegate;
    private final boolean isDeclaration;
    private final boolean isAbstract;
    private final boolean mayBeUsedAsSuperImplementation;

    public DescriptorBasedFunctionHandle(@NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.descriptor = descriptor2;
        this._overridden$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> DescriptorBasedFunctionHandle._overridden_delegate$lambda$1(this));
        this.isDeclaration = this.descriptor.getKind().isReal() || DeclarationUtilKt.findInterfaceImplementation$default(this.descriptor, false, 2, null) != null;
        this.isAbstract = this.descriptor.getModality() == Modality.ABSTRACT;
        this.mayBeUsedAsSuperImplementation = !DescriptorUtils.isInterface(this.descriptor.getContainingDeclaration());
    }

    @NotNull
    public final FunctionDescriptor getDescriptor() {
        return this.descriptor;
    }

    private final List<DescriptorBasedFunctionHandle> get_overridden() {
        Lazy lazy = this._overridden$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    protected DescriptorBasedFunctionHandle createHandleForOverridden(@NotNull FunctionDescriptor overridden) {
        Intrinsics.checkNotNullParameter(overridden, "overridden");
        return new DescriptorBasedFunctionHandle(overridden);
    }

    @Override
    public boolean isDeclaration() {
        return this.isDeclaration;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean getMayBeUsedAsSuperImplementation() {
        return this.mayBeUsedAsSuperImplementation;
    }

    @NotNull
    public List<DescriptorBasedFunctionHandle> getOverridden() {
        return this.get_overridden();
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof DescriptorBasedFunctionHandle && Intrinsics.areEqual(this.descriptor, ((DescriptorBasedFunctionHandle)other).descriptor);
    }

    @NotNull
    public String toString() {
        return this.descriptor.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final List _overridden_delegate$lambda$1(DescriptorBasedFunctionHandle this$0) {
        void $this$mapTo$iv$iv;
        Collection<? extends FunctionDescriptor> collection = this$0.descriptor.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            FunctionDescriptor functionDescriptor2 = it.getOriginal();
            Intrinsics.checkNotNullExpressionValue(functionDescriptor2, "getOriginal(...)");
            collection2.add(this$0.createHandleForOverridden(functionDescriptor2));
        }
        return (List)destination$iv$iv;
    }
}

