/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops.handlers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.loops.handlers.IndicesHandler;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/ArrayIndicesHandler;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/IndicesHandler;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "supportsUnsignedArrays", "", "matchIterable", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "sizePropertyGetter", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getSizePropertyGetter", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "ir.backend.common"})
public final class ArrayIndicesHandler
extends IndicesHandler {
    private final boolean supportsUnsignedArrays;

    public ArrayIndicesHandler(@NotNull CommonBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        super(context);
        this.supportsUnsignedArrays = context.getOptimizeLoopsOverUnsignedArrays();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matchIterable(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (!callee.getValueParameters().isEmpty()) return false;
        IrValueParameter irValueParameter = callee.getExtensionReceiverParameter();
        IrAnnotationContainer irAnnotationContainer = irValueParameter;
        if (irValueParameter == null) return false;
        IrType irType = irAnnotationContainer.getType();
        irAnnotationContainer = irType;
        if (irType == null) return false;
        IrAnnotationContainer irAnnotationContainer2 = irAnnotationContainer;
        boolean bl = false;
        if (!IrTypePredicatesKt.isArray((IrType)irAnnotationContainer2) && !IrTypeUtilsKt.isPrimitiveArray((IrType)irAnnotationContainer2)) {
            if (!this.supportsUnsignedArrays) return false;
            if (!IrTypeUtilsKt.isUnsignedArray((IrType)irAnnotationContainer2)) return false;
        }
        boolean bl2 = true;
        if (!bl2) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        if (!Intrinsics.areEqual(AdditionalIrUtilsKt.getKotlinFqName(callee), new FqName("kotlin.collections.<get-indices>"))) return false;
        return true;
    }

    @Override
    @NotNull
    public IrSimpleFunction getSizePropertyGetter(@NotNull IrType $this$sizePropertyGetter) {
        Intrinsics.checkNotNullParameter($this$sizePropertyGetter, "<this>");
        IrClass irClass = IrTypesKt.getClass($this$sizePropertyGetter);
        Intrinsics.checkNotNull(irClass);
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getPropertyGetter(irClass, "size");
        Intrinsics.checkNotNull(irSimpleFunctionSymbol);
        return (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
    }
}

