/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import org.jetbrains.kotlin.backend.common.serialization.IdSignatureDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerKind;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.library.IrLibrary;
import org.jetbrains.kotlin.library.KotlinAbiVersion;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u00a6\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH&J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\rH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\rH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000fH\u0016J\b\u0010%\u001a\u00020\u001fH\u0016J\b\u0010&\u001a\u00020\u001fH\u0016J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u0000H\u0016J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010)\u001a\u00020\u001fH\u0016J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020=0/H\u0016J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u000204H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0012\u0010*\u001a\u00020+X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0018\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00000/X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R \u00102\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020503X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0012\u00108\u001a\u000209X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0011\u0010>\u001a\u00020?8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010A\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "", "_moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "libraryAbiVersion", "Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/library/KotlinAbiVersion;)V", "getLibraryAbiVersion", "()Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "contains", "", "idSig", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "tryDeserializeIrSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "deserializedSymbolNotFound", "", "moduleDescriptor", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "referenceSimpleFunctionByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "idSignature", "referencePropertyByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "declareIrSymbol", "", "symbol", "klib", "Lorg/jetbrains/kotlin/library/IrLibrary;", "getKlib", "()Lorg/jetbrains/kotlin/library/IrLibrary;", "init", "postProcess", "delegate", "addModuleReachableTopLevel", "deserializeReachableDeclarations", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getModuleFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "moduleDependencies", "", "getModuleDependencies", "()Ljava/util/Collection;", "strategyResolver", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "getStrategyResolver", "()Lkotlin/jvm/functions/Function1;", "kind", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerKind;", "getKind", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerKind;", "fileDeserializers", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "compatibilityMode", "Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;", "getCompatibilityMode", "()Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;", "signatureDeserializerForFile", "Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer;", "fileName", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIrModuleDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrModuleDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,263:1\n1#2:264\n*E\n"})
public abstract class IrModuleDeserializer {
    @Nullable
    private final ModuleDescriptor _moduleDescriptor;
    @NotNull
    private final KotlinAbiVersion libraryAbiVersion;
    @NotNull
    private final Function1<String, DeserializationStrategy> strategyResolver;

    public IrModuleDeserializer(@Nullable ModuleDescriptor _moduleDescriptor, @NotNull KotlinAbiVersion libraryAbiVersion) {
        Intrinsics.checkNotNullParameter(libraryAbiVersion, "libraryAbiVersion");
        this._moduleDescriptor = _moduleDescriptor;
        this.libraryAbiVersion = libraryAbiVersion;
        this.strategyResolver = IrModuleDeserializer::strategyResolver$lambda$1;
    }

    @NotNull
    public final KotlinAbiVersion getLibraryAbiVersion() {
        return this.libraryAbiVersion;
    }

    public abstract boolean contains(@NotNull IdSignature var1);

    @Nullable
    public abstract IrSymbol tryDeserializeIrSymbol(@NotNull IdSignature var1, @NotNull BinarySymbolData.SymbolKind var2);

    @NotNull
    public abstract Void deserializedSymbolNotFound(@NotNull IdSignature var1);

    @NotNull
    public final ModuleDescriptor getModuleDescriptor() {
        ModuleDescriptor moduleDescriptor = this._moduleDescriptor;
        if (moduleDescriptor == null) {
            throw new IllegalStateException("No ModuleDescriptor provided".toString());
        }
        return moduleDescriptor;
    }

    @NotNull
    public IrSimpleFunctionSymbol referenceSimpleFunctionByLocalSignature(@NotNull IrFile file2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        throw new IllegalStateException("Unsupported operation".toString());
    }

    @NotNull
    public IrPropertySymbol referencePropertyByLocalSignature(@NotNull IrFile file2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        throw new IllegalStateException("Unsupported operation".toString());
    }

    public void declareIrSymbol(@NotNull IrSymbol symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        IdSignature signature2 = symbol.getSignature();
        if (!(signature2 != null)) {
            boolean bl = false;
            String string2 = "Symbol is not public API: " + symbol.getDescriptor();
            throw new IllegalArgumentException(string2.toString());
        }
        boolean bl = symbol.getHasDescriptor();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        IrModuleDeserializerKt.deserializeIrSymbolOrFail(this, signature2, IrModuleDeserializerKt.kind(symbol));
    }

    @NotNull
    public IrLibrary getKlib() {
        throw new IllegalStateException("Unsupported operation".toString());
    }

    public void init() {
        this.init(this);
    }

    public void postProcess() {
    }

    public void init(@NotNull IrModuleDeserializer delegate) {
        Intrinsics.checkNotNullParameter(delegate, "delegate");
    }

    public void addModuleReachableTopLevel(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        throw new IllegalStateException(("Unsupported Operation (sig: " + idSig).toString());
    }

    public void deserializeReachableDeclarations() {
        throw new IllegalStateException("Unsupported Operation".toString());
    }

    @NotNull
    public abstract IrModuleFragment getModuleFragment();

    @NotNull
    public abstract Collection<IrModuleDeserializer> getModuleDependencies();

    @NotNull
    public Function1<String, DeserializationStrategy> getStrategyResolver() {
        return this.strategyResolver;
    }

    @NotNull
    public abstract IrModuleDeserializerKind getKind();

    @NotNull
    public Collection<IrFileDeserializer> fileDeserializers() {
        throw new IllegalStateException("Unsupported".toString());
    }

    @NotNull
    public final CompatibilityMode getCompatibilityMode() {
        return new CompatibilityMode(this.libraryAbiVersion);
    }

    @NotNull
    public IdSignatureDeserializer signatureDeserializerForFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        throw new IllegalStateException("Unsupported".toString());
    }

    private static final DeserializationStrategy strategyResolver$lambda$1(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return DeserializationStrategy.ONLY_DECLARATION_HEADERS;
    }
}

