/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicFunction;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IteratorNext;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "<init>", "()V", "toCallable", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "signature", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;", "classCodegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "getKotlinPrimitiveClassName", "Lorg/jetbrains/kotlin/name/Name;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "getPrimitiveIteratorType", "primitiveClassName", "backend.jvm.codegen"})
public final class IteratorNext
extends IntrinsicMethod {
    @NotNull
    public static final IteratorNext INSTANCE = new IteratorNext();

    private IteratorNext() {
    }

    @Override
    @NotNull
    public IntrinsicFunction toCallable(@NotNull IrFunctionAccessExpression expression2, @NotNull JvmMethodSignature signature2, @NotNull ClassCodegen classCodegen) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(signature2, "signature");
        Intrinsics.checkNotNullParameter(classCodegen, "classCodegen");
        Type type2 = AsmUtil.isBoxedPrimitiveType(signature2.getReturnType()) ? AsmUtil.unboxType(signature2.getReturnType()) : signature2.getReturnType();
        Intrinsics.checkNotNull(type2);
        Type type3 = type2;
        JvmMethodSignature newSignature = IntrinsicMethod.Companion.newReturnType(signature2, type3);
        Name primitiveClassName = this.getKotlinPrimitiveClassName(type3);
        return IntrinsicFunction.Companion.create(expression2, newSignature, classCodegen, CollectionsKt.listOf(this.getPrimitiveIteratorType(primitiveClassName)), (arg_0, arg_1) -> IteratorNext.toCallable$lambda$0(primitiveClassName, type3, arg_0, arg_1));
    }

    private final Name getKotlinPrimitiveClassName(Type type2) {
        return JvmPrimitiveType.get(type2.getClassName()).getPrimitiveType().getTypeName();
    }

    private final Type getPrimitiveIteratorType(Name primitiveClassName) {
        Name name = Name.identifier(primitiveClassName.asString() + "Iterator");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
        Name iteratorName = name;
        FqName fqName2 = StandardNames.COLLECTIONS_PACKAGE_FQ_NAME.child(iteratorName);
        Intrinsics.checkNotNullExpressionValue(fqName2, "child(...)");
        Type type2 = Type.getObjectType(JvmFileClassUtilKt.getInternalNameWithoutInnerClasses(fqName2));
        Intrinsics.checkNotNullExpressionValue(type2, "getObjectType(...)");
        return type2;
    }

    private static final Unit toCallable$lambda$0(Name $primitiveClassName, Type $type, IntrinsicFunction $this$create, InstructionAdapter it) {
        Intrinsics.checkNotNullParameter($this$create, "$this$create");
        Intrinsics.checkNotNullParameter(it, "it");
        it.invokevirtual(INSTANCE.getPrimitiveIteratorType($primitiveClassName).getInternalName(), "next" + $primitiveClassName.asString(), "()" + $type.getDescriptor(), false);
        return Unit.INSTANCE;
    }
}

