/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrIfThenElseImpl;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@PhaseDescription(name="JvmLateinitLowering", description="Lower lateinit properties and variables")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Transformer", "backend.jvm.lower"})
public final class JvmLateinitLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public JvmLateinitLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        Transformer transformer2 = new Transformer(this.context);
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, transformer2);
        for (IrVariable variable : transformer2.getLateinitVariables()) {
            variable.setLateinit(false);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u000eH\u0002J\f\u0010\u001a\u001a\u00020\u0019*\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u0010#\u001a\u00020\u0013*\u00020$2\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "backendContext", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lateinitVariables", "", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getLateinitVariables", "()Ljava/util/List;", "visitField", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitVariable", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "isLateinitBackingField", "", "isRealLateinit", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "transformGetter", "", "backingField", "getter", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "throwUninitializedPropertyAccessException", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "name", "", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nJvmLateinitLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmLateinitLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering$Transformer\n+ 2 LateinitLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LateinitLoweringKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n218#2,12:175\n1#3:187\n*S KotlinDebug\n*F\n+ 1 JvmLateinitLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering$Transformer\n*L\n125#1:175,12\n*E\n"})
    private static final class Transformer
    extends IrElementTransformerVoid {
        @NotNull
        private final JvmBackendContext backendContext;
        @NotNull
        private final List<IrVariable> lateinitVariables;

        public Transformer(@NotNull JvmBackendContext backendContext) {
            Intrinsics.checkNotNullParameter(backendContext, "backendContext");
            this.backendContext = backendContext;
            this.lateinitVariables = new ArrayList();
        }

        @NotNull
        public final List<IrVariable> getLateinitVariables() {
            return this.lateinitVariables;
        }

        @Override
        @NotNull
        public IrStatement visitField(@NotNull IrField declaration) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            if (this.isLateinitBackingField(declaration)) {
                boolean bl;
                boolean bl2 = bl = declaration.getInitializer() == null;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "lateinit property backing field should not have an initializer:\n" + DumpIrTreeKt.dump$default(declaration, null, 1, null);
                    throw new AssertionError((Object)string2);
                }
                declaration.setType(IrTypesKt.makeNullable(declaration.getType()));
            }
            this.transformChildrenVoid(declaration);
            return declaration;
        }

        @Override
        @NotNull
        public IrStatement visitVariable(@NotNull IrVariable declaration) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
            if (declaration.isLateinit()) {
                declaration.setType(IrTypesKt.makeNullable(declaration.getType()));
                declaration.setVar(true);
                declaration.setInitializer(IrConstImpl.Companion.constNull(declaration.getStartOffset(), declaration.getEndOffset(), this.backendContext.getIrBuiltIns().getNothingNType()));
                ((Collection)this.lateinitVariables).add(declaration);
            }
            return declaration;
        }

        @Override
        @NotNull
        public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
            IrProperty property;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            IrPropertySymbol irPropertySymbol = declaration.getCorrespondingPropertySymbol();
            IrProperty irProperty = property = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            if (property != null && this.isRealLateinit(property) && Intrinsics.areEqual(declaration, property.getGetter())) {
                IrField irField = property.getBackingField();
                Intrinsics.checkNotNull(irField);
                this.transformGetter(irField, declaration);
                return declaration;
            }
            this.transformChildrenVoid(declaration);
            return declaration;
        }

        @Override
        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrValueDeclaration irValue = expression2.getSymbol().getOwner();
            if (!(irValue instanceof IrVariable) || !((IrVariable)irValue).isLateinit()) {
                return expression2;
            }
            BackendContext backendContext = this.backendContext;
            IrDeclarationParent irDeclarationParent = ((IrVariable)irValue).getParent();
            Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
            DeclarationIrBuilder $this$visitGetValue_u24lambda_u241 = LowerUtilsKt.createIrBuilder(backendContext, ((IrSymbolOwner)((Object)irDeclarationParent)).getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
            boolean bl = false;
            IrBuilderWithScope irBuilderWithScope = $this$visitGetValue_u24lambda_u241;
            IrType irType = expression2.getType();
            IrExpression irExpression = ExpressionHelpersKt.irEqualsNull($this$visitGetValue_u24lambda_u241, ExpressionHelpersKt.irGet($this$visitGetValue_u24lambda_u241, irValue));
            IrBuilderWithScope irBuilderWithScope2 = $this$visitGetValue_u24lambda_u241;
            String string2 = irValue.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            return ExpressionHelpersKt.irIfThenElse$default(irBuilderWithScope, irType, irExpression, this.backendContext.throwUninitializedPropertyAccessException(irBuilderWithScope2, string2), ExpressionHelpersKt.irGet($this$visitGetValue_u24lambda_u241, irValue), null, 16, null);
        }

        @Override
        @NotNull
        public IrExpression visitGetField(@NotNull IrGetField expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrField irField = (IrField)expression2.getSymbol().getOwner();
            if (this.isLateinitBackingField(irField)) {
                expression2.setType(IrTypesKt.makeNullable(expression2.getType()));
            }
            return expression2;
        }

        private final boolean isLateinitBackingField(IrField $this$isLateinitBackingField) {
            IrPropertySymbol irPropertySymbol = $this$isLateinitBackingField.getCorrespondingPropertySymbol();
            IrProperty property = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            return property != null && this.isRealLateinit(property);
        }

        private final boolean isRealLateinit(IrProperty $this$isRealLateinit) {
            return $this$isRealLateinit.isLateinit() && !$this$isRealLateinit.isFakeOverride();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2) {
            IrExpression irExpression;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            if (!Symbols.Companion.isLateinitIsInitializedPropertyGetter(expression2.getSymbol())) {
                return expression2;
            }
            IrExpression irExpression2 = expression2.getExtensionReceiver();
            Intrinsics.checkNotNull(irExpression2);
            IrExpression $this$replaceTailExpression$iv = irExpression2;
            boolean $i$f$replaceTailExpression = false;
            IrExpression current$iv = $this$replaceTailExpression$iv;
            IrContainerExpression block$iv = null;
            while (current$iv instanceof IrContainerExpression) {
                block$iv = (IrContainerExpression)current$iv;
                IrStatement irStatement = CollectionsKt.last(((IrContainerExpression)current$iv).getStatements());
                Intrinsics.checkNotNull(irStatement, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                current$iv = (IrExpression)irStatement;
            }
            IrExpression it = current$iv;
            boolean bl = false;
            IrPropertyReference irPropertyReference = it instanceof IrPropertyReference ? (IrPropertyReference)it : null;
            if (irPropertyReference == null) {
                throw new AssertionError((Object)("Property reference expected: " + RenderIrElementKt.render$default(it, null, 1, null)));
            }
            IrPropertyReference irPropertyRef = irPropertyReference;
            Object object = irPropertyRef.getGetter();
            if (object == null || (object = (IrSimpleFunction)object.getOwner()) == null || (object = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default((IrOverridableDeclaration)object, null, 1, null)) == null || (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) == null || (object = (IrProperty)object.getOwner()) == null) {
                throw new AssertionError((Object)("isInitialized cannot be invoked on " + RenderIrElementKt.render$default(it, null, 1, null)));
            }
            Object property = object;
            if (!((IrProperty)property).isLateinit()) {
                boolean bl2 = false;
                String string2 = "isInitialized invoked on non-lateinit property " + RenderIrElementKt.render$default((IrElement)property, null, 1, null);
                throw new IllegalArgumentException(string2.toString());
            }
            IrField irField = ((IrProperty)property).getBackingField();
            if (irField == null) {
                throw new AssertionError((Object)"Lateinit property is supposed to have a backing field");
            }
            IrField backingField = irField;
            DeclarationIrBuilder $this$visitCall_u24lambda_u244_u24lambda_u243 = LowerUtilsKt.createIrBuilder(this.backendContext, ((IrPropertyReference)it).getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
            boolean bl3 = false;
            current$iv = ExpressionHelpersKt.irNotEquals($this$visitCall_u24lambda_u244_u24lambda_u243, ExpressionHelpersKt.irGetField$default($this$visitCall_u24lambda_u244_u24lambda_u243, ((IrPropertyReference)it).getDispatchReceiver(), backingField, null, 4, null), ExpressionHelpersKt.irNull($this$visitCall_u24lambda_u244_u24lambda_u243));
            if (block$iv == null) {
                irExpression = current$iv;
            } else {
                void var2_2;
                block$iv.getStatements().set(block$iv.getStatements().size() - 1, current$iv);
                irExpression = var2_2;
            }
            return irExpression;
        }

        private final void transformGetter(IrField backingField, IrFunction getter2) {
            boolean bl;
            IrType type2 = backingField.getType();
            boolean bl2 = bl = !IrTypePredicatesKt.isPrimitiveType$default(type2, false, 1, null);
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-JvmLateinitLowering$Transformer$transformGetter$22 = false;
                String $i$a$-assert-JvmLateinitLowering$Transformer$transformGetter$22 = "'lateinit' property type should not be primitive:\n" + DumpIrTreeKt.dump$default(backingField, null, 1, null);
                throw new AssertionError((Object)$i$a$-assert-JvmLateinitLowering$Transformer$transformGetter$22);
            }
            int startOffset = getter2.getStartOffset();
            int endOffset = getter2.getEndOffset();
            getter2.setBody(IrFactoryHelpersKt.createBlockBody(this.backendContext.getIrFactory(), startOffset, endOffset, arg_0 -> Transformer.transformGetter$lambda$8(this, getter2, startOffset, endOffset, backingField, arg_0)));
        }

        private final IrExpression throwUninitializedPropertyAccessException(IrBuilderWithScope $this$throwUninitializedPropertyAccessException, String name) {
            return this.backendContext.throwUninitializedPropertyAccessException($this$throwUninitializedPropertyAccessException, name);
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit transformGetter$lambda$8(Transformer this$0, IrFunction $getter, int $startOffset, int $endOffset, IrField $backingField, IrBlockBody $this$createBlockBody) {
            IrGetValueImpl irGetValueImpl;
            DeclarationIrBuilder irBuilder;
            Intrinsics.checkNotNullParameter($this$createBlockBody, "$this$createBlockBody");
            DeclarationIrBuilder $this$transformGetter_u24lambda_u248_u24lambda_u247 = irBuilder = LowerUtilsKt.createIrBuilder(this$0.backendContext, (IrSymbol)$getter.getSymbol(), $startOffset, $endOffset);
            boolean bl = false;
            Scope scope2 = $this$transformGetter_u24lambda_u248_u24lambda_u247.getScope();
            IrBuilderWithScope irBuilderWithScope = $this$transformGetter_u24lambda_u248_u24lambda_u247;
            IrValueParameter irValueParameter = $getter.getDispatchReceiverParameter();
            if (irValueParameter != null) {
                void it;
                IrValueParameter irValueParameter2 = irValueParameter;
                IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
                Scope scope3 = scope2;
                boolean bl2 = false;
                IrGetValueImpl irGetValueImpl2 = ExpressionHelpersKt.irGet($this$transformGetter_u24lambda_u248_u24lambda_u247, (IrValueDeclaration)it);
                scope2 = scope3;
                irBuilderWithScope = irBuilderWithScope2;
                irGetValueImpl = irGetValueImpl2;
            } else {
                irGetValueImpl = null;
            }
            IrVariable resultVar = IrBuilderKt.createTmpVariable$default(scope2, (IrExpression)ExpressionHelpersKt.irGetField(irBuilderWithScope, irGetValueImpl, $backingField, IrTypesKt.makeNullable($backingField.getType())), null, false, null, null, 30, null);
            resultVar.setParent($getter);
            $this$createBlockBody.getStatements().add(resultVar);
            IrBuilderWithScope irBuilderWithScope3 = $this$transformGetter_u24lambda_u248_u24lambda_u247;
            IrType irType = $this$transformGetter_u24lambda_u248_u24lambda_u247.getContext().getIrBuiltIns().getNothingType();
            IrExpression irExpression = ExpressionHelpersKt.irNotEquals($this$transformGetter_u24lambda_u248_u24lambda_u247, ExpressionHelpersKt.irGet($this$transformGetter_u24lambda_u248_u24lambda_u247, resultVar), ExpressionHelpersKt.irNull($this$transformGetter_u24lambda_u248_u24lambda_u247));
            IrExpression irExpression2 = ExpressionHelpersKt.irReturn($this$transformGetter_u24lambda_u248_u24lambda_u247, ExpressionHelpersKt.irGet($this$transformGetter_u24lambda_u248_u24lambda_u247, resultVar));
            IrBuilderWithScope irBuilderWithScope4 = $this$transformGetter_u24lambda_u248_u24lambda_u247;
            String string2 = $backingField.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            IrIfThenElseImpl throwIfNull = ExpressionHelpersKt.irIfThenElse$default(irBuilderWithScope3, irType, irExpression, irExpression2, this$0.throwUninitializedPropertyAccessException(irBuilderWithScope4, string2), null, 16, null);
            $this$createBlockBody.getStatements().add(throwIfNull);
            return Unit.INSTANCE;
        }
    }
}

