/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.preprocessor;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.preprocessor.IrInterpreterPreprocessor;
import org.jetbrains.kotlin.ir.interpreter.preprocessor.IrInterpreterPreprocessorData;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u000f*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u000fH\u0002J\n\u0010\u0016\u001a\u00020\u0015*\u00020\u0013\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterConstGetterPreprocessor;", "Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterPreprocessor;", "<init>", "()V", "visitFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "data", "Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterPreprocessorData;", "visitCall", "Lorg/jetbrains/kotlin/ir/IrElement;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "lowerConstRead", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "shouldDropConstReceiver", "", "hasConstantValue", "ir.interpreter"})
public final class IrInterpreterConstGetterPreprocessor
implements IrInterpreterPreprocessor {
    @Override
    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration, @NotNull IrInterpreterPreprocessorData data2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(data2, "data");
        if (Intrinsics.areEqual(declaration.getOrigin(), IrDeclarationOrigin.Companion.getDEFAULT_PROPERTY_ACCESSOR())) {
            return declaration;
        }
        return IrInterpreterPreprocessor.DefaultImpls.visitFunction(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitCall(@NotNull IrCall expression2, @NotNull IrInterpreterPreprocessorData data2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        IrDeclarationBase irDeclarationBase = UtilsKt.getCorrespondingProperty(expression2);
        if (irDeclarationBase == null || (irDeclarationBase = irDeclarationBase.getBackingField()) == null) {
            return IrInterpreterPreprocessor.DefaultImpls.visitCall(this, expression2, data2);
        }
        IrDeclarationBase field = irDeclarationBase;
        IrExpression irExpression = this.lowerConstRead(expression2, (IrField)field, data2);
        return irExpression != null ? (IrElement)irExpression : IrInterpreterPreprocessor.DefaultImpls.visitCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull IrInterpreterPreprocessorData data2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        IrExpression irExpression = this.lowerConstRead(expression2, (IrField)expression2.getSymbol().getOwner(), data2);
        if (irExpression == null) {
            irExpression = IrInterpreterPreprocessor.DefaultImpls.visitGetField(this, expression2, data2);
        }
        return irExpression;
    }

    private final IrExpression lowerConstRead(IrExpression $this$lowerConstRead, IrField field, IrInterpreterPreprocessorData data2) {
        IrExpression irExpression;
        IrExpression irExpression2;
        IrExpression irExpression3 = $this$lowerConstRead;
        if (irExpression3 instanceof IrCall) {
            irExpression2 = ((IrCall)$this$lowerConstRead).getDispatchReceiver();
        } else if (irExpression3 instanceof IrGetField) {
            irExpression2 = ((IrGetField)$this$lowerConstRead).getReceiver();
        } else {
            return null;
        }
        IrExpression receiver = irExpression2;
        if (receiver == null || !this.hasConstantValue(field)) {
            return null;
        }
        $this$lowerConstRead.transformChildren(this, data2);
        IrClass fieldParent = IrUtilsKt.getParentAsClass(field);
        IrGetObjectValueImpl getObject = BuildersKt.IrGetObjectValueImpl(-1, -1, IrUtilsKt.getDefaultType(fieldParent), fieldParent.getSymbol());
        IrExpression[] irExpressionArray = (IrExpression[])$this$lowerConstRead;
        if (irExpressionArray instanceof IrCall) {
            ((IrCall)$this$lowerConstRead).setDispatchReceiver(getObject);
        } else if (irExpressionArray instanceof IrGetField) {
            ((IrGetField)$this$lowerConstRead).setReceiver(getObject);
        }
        if (this.shouldDropConstReceiver(receiver)) {
            irExpression = $this$lowerConstRead;
        } else {
            irExpressionArray = new IrExpression[]{receiver, $this$lowerConstRead};
            irExpression = new IrCompositeImpl($this$lowerConstRead.getStartOffset(), $this$lowerConstRead.getEndOffset(), $this$lowerConstRead.getType(), null, CollectionsKt.listOf(irExpressionArray));
        }
        return irExpression;
    }

    private final boolean shouldDropConstReceiver(IrExpression $this$shouldDropConstReceiver) {
        return $this$shouldDropConstReceiver instanceof IrGetValue || $this$shouldDropConstReceiver instanceof IrGetObjectValue;
    }

    public final boolean hasConstantValue(@NotNull IrField $this$hasConstantValue) {
        Intrinsics.checkNotNullParameter($this$hasConstantValue, "<this>");
        boolean implicitConst = $this$hasConstantValue.isFinal() && $this$hasConstantValue.isStatic() && Intrinsics.areEqual($this$hasConstantValue.getOrigin(), IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB()) && $this$hasConstantValue.getInitializer() != null;
        return implicitConst || UtilsKt.isConst(UtilsKt.getProperty($this$hasConstantValue));
    }

    @Override
    @NotNull
    public IrElement visitElement(@NotNull IrElement element, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitElement(this, element, data2);
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitDeclaration(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitValueParameter(@NotNull IrValueParameter declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitValueParameter(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitClass(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitTypeParameter(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitConstructor(@NotNull IrConstructor declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitConstructor(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitEnumEntry(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitField(@NotNull IrField declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitField(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitModuleFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitProperty(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitScript(@NotNull IrScript declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitScript(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitSimpleFunction(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitTypeAlias(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitVariable(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitPackageFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrFile visitFile(@NotNull IrFile declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitFile(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitExpression(@NotNull IrExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrBody visitBody(@NotNull IrBody body2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitBody(this, body2, data2);
    }

    @Override
    @NotNull
    public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitExpressionBody(this, body2, data2);
    }

    @Override
    @NotNull
    public IrBody visitBlockBody(@NotNull IrBlockBody body2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitBlockBody(this, body2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitDeclarationReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitMemberAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitFunctionAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitConstructorCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitSingletonReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitGetObjectValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitGetEnumValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitContainerExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitBlock(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitComposite(@NotNull IrComposite expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitComposite(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitReturnableBlock(@NotNull IrReturnableBlock expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitReturnableBlock(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data2);
    }

    @Override
    @NotNull
    public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitSyntheticBody(this, body2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitBreakContinue(this, jump, data2);
    }

    @Override
    @NotNull
    public IrExpression visitBreak(@NotNull IrBreak jump, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitBreak(this, jump, data2);
    }

    @Override
    @NotNull
    public IrExpression visitContinue(@NotNull IrContinue jump, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitContinue(this, jump, data2);
    }

    @Override
    @NotNull
    public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitCallableReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitFunctionReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitPropertyReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitClassReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitConst(@NotNull IrConst<?> expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitConst(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantValue(@NotNull IrConstantValue expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitConstantValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantObject(@NotNull IrConstantObject expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitConstantObject(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantArray(@NotNull IrConstantArray expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitConstantArray(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitDynamicExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitErrorExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitFieldAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitSetField(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitFunctionExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitGetClass(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitLoop(@NotNull IrLoop loop, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitLoop(this, loop, data2);
    }

    @Override
    @NotNull
    public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitWhileLoop(this, loop, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitDoWhileLoop(this, loop, data2);
    }

    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitReturn(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitStringConcatenation(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitThrow(@NotNull IrThrow expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitThrow(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitTry(@NotNull IrTry aTry, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitTry(this, aTry, data2);
    }

    @Override
    @NotNull
    public IrCatch visitCatch(@NotNull IrCatch aCatch, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitCatch(this, aCatch, data2);
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitTypeOperator(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitValueAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitGetValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSetValue(@NotNull IrSetValue expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitSetValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitVararg(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitSpreadElement(this, spread, data2);
    }

    @Override
    @NotNull
    public IrExpression visitWhen(@NotNull IrWhen expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitWhen(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrBranch visitBranch(@NotNull IrBranch branch, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitBranch(this, branch, data2);
    }

    @Override
    @NotNull
    public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitElseBranch(this, branch, data2);
    }
}

