/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoExtensionsKt;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCase;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallInfo;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\u00020\t*\u00020\u0007H\u0014\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/js/translate/callTranslator/DynamicInvokeAndBracketAccessCallCase;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallCase;", "<init>", "()V", "canApply", "", "callInfo", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;", "dispatchReceiver", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "js.translator"})
public final class DynamicInvokeAndBracketAccessCallCase
extends FunctionCallCase {
    @NotNull
    public static final DynamicInvokeAndBracketAccessCallCase INSTANCE = new DynamicInvokeAndBracketAccessCallCase();

    private DynamicInvokeAndBracketAccessCallCase() {
    }

    public final boolean canApply(@NotNull FunctionCallInfo callInfo) {
        Intrinsics.checkNotNullParameter(callInfo, "callInfo");
        if (!DynamicCallsKt.isDynamic(CallInfoExtensionsKt.getCallableDescriptor(callInfo))) {
            return false;
        }
        Call.CallType callType = callInfo.getResolvedCall().getCall().getCallType();
        Intrinsics.checkNotNullExpressionValue((Object)callType, "getCallType(...)");
        Call.CallType callType2 = callType;
        return callType2 == Call.CallType.ARRAY_GET_METHOD || callType2 == Call.CallType.ARRAY_SET_METHOD || callType2 == Call.CallType.INVOKE;
    }

    @Override
    @NotNull
    protected JsExpression dispatchReceiver(@NotNull FunctionCallInfo $this$dispatchReceiver) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter($this$dispatchReceiver, "<this>");
        List<JsExpression> arguments2 = $this$dispatchReceiver.getArgumentsInfo().getTranslateArguments();
        Call.CallType callType = $this$dispatchReceiver.getResolvedCall().getCall().getCallType();
        Intrinsics.checkNotNullExpressionValue((Object)callType, "getCallType(...)");
        Call.CallType callType2 = callType;
        switch (WhenMappings.$EnumSwitchMapping$0[callType2.ordinal()]) {
            case 1: {
                JsExpression jsExpression2 = $this$dispatchReceiver.getDispatchReceiver();
                Intrinsics.checkNotNull(jsExpression2);
                jsExpression = new JsInvocation(jsExpression2, arguments2);
                break;
            }
            case 2: {
                jsExpression = new JsArrayAccess($this$dispatchReceiver.getDispatchReceiver(), arguments2.get(0));
                break;
            }
            case 3: {
                JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(new JsArrayAccess($this$dispatchReceiver.getDispatchReceiver(), arguments2.get(0)), arguments2.get(1));
                Intrinsics.checkNotNullExpressionValue(jsBinaryOperation, "assignment(...)");
                jsExpression = jsBinaryOperation;
                break;
            }
            default: {
                this.unsupported((CallInfo)$this$dispatchReceiver, "Unsupported call type: " + (Object)((Object)callType2) + ", callInfo: " + $this$dispatchReceiver);
                throw null;
            }
        }
        return jsExpression;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Call.CallType.values().length];
            try {
                nArray[Call.CallType.INVOKE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Call.CallType.ARRAY_GET_METHOD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Call.CallType.ARRAY_SET_METHOD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

