/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.SealedClassInheritorsProvider;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/resolve/CliSealedClassInheritorsProvider;", "Lorg/jetbrains/kotlin/resolve/SealedClassInheritorsProvider;", "<init>", "()V", "computeSealedSubclasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "sealedClass", "allowSealedInheritorsInDifferentFilesOfSamePackage", "", "descriptors"})
@SourceDebugExtension(value={"SMAP\nSealedClassInheritorsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SealedClassInheritorsProvider.kt\norg/jetbrains/kotlin/resolve/CliSealedClassInheritorsProvider\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n183#2,2:87\n1053#3:89\n*S KotlinDebug\n*F\n+ 1 SealedClassInheritorsProvider.kt\norg/jetbrains/kotlin/resolve/CliSealedClassInheritorsProvider\n*L\n73#1:87,2\n82#1:89\n*E\n"})
public final class CliSealedClassInheritorsProvider
extends SealedClassInheritorsProvider {
    @NotNull
    public static final CliSealedClassInheritorsProvider INSTANCE = new CliSealedClassInheritorsProvider();

    private CliSealedClassInheritorsProvider() {
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> computeSealedSubclasses(@NotNull ClassDescriptor sealedClass, boolean allowSealedInheritorsInDifferentFilesOfSamePackage) {
        DeclarationDescriptor container;
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter(sealedClass, "sealedClass");
        if (sealedClass.getModality() != Modality.SEALED) {
            return CollectionsKt.emptyList();
        }
        LinkedHashSet<ClassDescriptor> result2 = new LinkedHashSet<ClassDescriptor>();
        if (!allowSealedInheritorsInDifferentFilesOfSamePackage) {
            declarationDescriptor = sealedClass.getContainingDeclaration();
        } else {
            DeclarationDescriptor declarationDescriptor2;
            block5: {
                Sequence<DeclarationDescriptor> $this$firstOrNull$iv = DescriptorUtilsKt.getParents(sealedClass);
                boolean $i$f$firstOrNull = false;
                Iterator<DeclarationDescriptor> iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    DeclarationDescriptor element$iv;
                    DeclarationDescriptor it = element$iv = iterator2.next();
                    boolean bl = false;
                    if (!(it instanceof PackageFragmentDescriptor)) continue;
                    declarationDescriptor2 = element$iv;
                    break block5;
                }
                declarationDescriptor2 = null;
            }
            declarationDescriptor = container = (DeclarationDescriptor)declarationDescriptor2;
        }
        if (container instanceof PackageFragmentDescriptor) {
            CliSealedClassInheritorsProvider.computeSealedSubclasses$collectSubclasses(sealedClass, result2, ((PackageFragmentDescriptor)container).getMemberScope(), allowSealedInheritorsInDifferentFilesOfSamePackage);
        }
        MemberScope memberScope2 = sealedClass.getUnsubstitutedInnerClassesScope();
        Intrinsics.checkNotNullExpressionValue(memberScope2, "getUnsubstitutedInnerClassesScope(...)");
        CliSealedClassInheritorsProvider.computeSealedSubclasses$collectSubclasses(sealedClass, result2, memberScope2, true);
        Iterable $this$sortedBy$iv = result2;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                ClassDescriptor it = (ClassDescriptor)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)DescriptorUtilsKt.getFqNameSafe(it).asString());
                it = (ClassDescriptor)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)DescriptorUtilsKt.getFqNameSafe(it).asString()));
            }
        });
    }

    private static final void computeSealedSubclasses$collectSubclasses(ClassDescriptor $sealedClass, LinkedHashSet<ClassDescriptor> result2, MemberScope scope2, boolean collectNested) {
        for (DeclarationDescriptor descriptor2 : ResolutionScope.DefaultImpls.getContributedDescriptors$default(scope2, DescriptorKindFilter.CLASSIFIERS, null, 2, null)) {
            ClassDescriptor classDescriptor;
            if (!(descriptor2 instanceof ClassDescriptor)) continue;
            if (((ClassDescriptor)descriptor2).isExpect()) {
                Name name = ((ClassDescriptor)descriptor2).getName();
                Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
                ClassifierDescriptor actualDescriptor = scope2.getContributedClassifier(name, NoLookupLocation.WHEN_GET_ALL_DESCRIPTORS);
                classDescriptor = actualDescriptor instanceof ClassDescriptor ? (ClassDescriptor)actualDescriptor : (actualDescriptor instanceof TypeAliasDescriptor ? ((TypeAliasDescriptor)actualDescriptor).getClassDescriptor() : null);
            } else {
                classDescriptor = (ClassDescriptor)descriptor2;
            }
            if (classDescriptor == null) continue;
            ClassDescriptor refinedDescriptor = classDescriptor;
            if (DescriptorUtils.isDirectSubclass(refinedDescriptor, $sealedClass)) {
                result2.add(refinedDescriptor);
            }
            if (!collectNested) continue;
            MemberScope memberScope2 = refinedDescriptor.getUnsubstitutedInnerClassesScope();
            Intrinsics.checkNotNullExpressionValue(memberScope2, "getUnsubstitutedInnerClassesScope(...)");
            CliSealedClassInheritorsProvider.computeSealedSubclasses$collectSubclasses($sealedClass, result2, memberScope2, collectNested);
        }
    }
}

