/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/DataClassResolver;", "", "<init>", "()V", "createComponentName", "Lorg/jetbrains/kotlin/name/Name;", "index", "", "getComponentIndex", "componentName", "", "isComponentLike", "", "name", "isCopy", "frontend.common"})
public final class DataClassResolver {
    @NotNull
    public static final DataClassResolver INSTANCE = new DataClassResolver();

    private DataClassResolver() {
    }

    @NotNull
    public final Name createComponentName(int index) {
        Name name = Name.identifier(StandardNames.DATA_CLASS_COMPONENT_PREFIX + index);
        Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
        return name;
    }

    public final int getComponentIndex(@NotNull String componentName) {
        Intrinsics.checkNotNullParameter(componentName, "componentName");
        String string2 = componentName.substring(StandardNames.DATA_CLASS_COMPONENT_PREFIX.length());
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        return Integer.parseInt(string2);
    }

    public final boolean isComponentLike(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string2 = name.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        return this.isComponentLike(string2);
    }

    public final boolean isComponentLike(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        if (!StringsKt.startsWith$default(name, StandardNames.DATA_CLASS_COMPONENT_PREFIX, false, 2, null)) {
            return false;
        }
        try {
            this.getComponentIndex(name);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public final boolean isCopy(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return Intrinsics.areEqual(name, StandardNames.DATA_CLASS_COPY);
    }
}

