/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.ConflictingOverloadsDispatcher;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.OverloadFilter;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0002JS\u0010\u001e\u001a\u00020\u00132\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u0004\u001a\u00020\u00052\u001e\u0010#\u001a\u001a\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0!0$H\u0082\bJ?\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001d0!2\u0006\u0010(\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u00052\u001e\u0010#\u001a\u001a\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0!0$H\u0082\bJ\u001e\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00190!H\u0002J\u0016\u0010-\u001a\u00020\u00132\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001d0!H\u0002J\"\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0!0!2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001d0!H\u0002J\f\u00100\u001a\u000201*\u00020\"H\u0002J\u0016\u0010)\u001a\u00020\u00132\f\u0010.\u001a\b\u0012\u0004\u0012\u0002020!H\u0002J\f\u00103\u001a\u000201*\u00020\"H\u0002J\u001c\u00104\u001a\b\u0012\u0004\u0012\u00020\u001d0!2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001d0!H\u0002J\u0018\u00105\u001a\u0002012\u0006\u00106\u001a\u00020\"2\u0006\u00107\u001a\u00020\"H\u0002J\u0018\u00108\u001a\u0002012\u0006\u00106\u001a\u00020\"2\u0006\u00107\u001a\u00020\"H\u0002J\u0018\u00109\u001a\u0002012\u0006\u0010:\u001a\u00020\"2\u0006\u0010;\u001a\u00020\"H\u0002J\u0018\u0010<\u001a\u0002012\u0006\u00106\u001a\u00020\u001d2\u0006\u00107\u001a\u00020\u001dH\u0002J\u0016\u0010=\u001a\u00020\u00132\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001d0!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/resolve/OverloadResolver;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "overloadFilter", "Lorg/jetbrains/kotlin/resolve/OverloadFilter;", "overloadChecker", "Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "errorDispatcher", "Lorg/jetbrains/kotlin/resolve/ConflictingOverloadsDispatcher;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "mainFunctionDetectorFactory", "Lorg/jetbrains/kotlin/idea/MainFunctionDetector$Factory;", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/OverloadFilter;Lorg/jetbrains/kotlin/resolve/OverloadChecker;Lorg/jetbrains/kotlin/resolve/ConflictingOverloadsDispatcher;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/idea/MainFunctionDetector$Factory;)V", "mainFunctionDetector", "Lorg/jetbrains/kotlin/idea/MainFunctionDetector;", "checkOverloads", "", "c", "Lorg/jetbrains/kotlin/resolve/BodiesResolveContext;", "findConstructorsInNestedClassesAndTypeAliases", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkOverloadsInPackages", "groupModulePackageMembersByFqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorNonRoot;", "collectModulePackageMembersWithSameName", "packageMembersByName", "interestingDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getMembersByName", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "Lorg/jetbrains/kotlin/name/Name;", "getModulePackageMembersWithSameName", "descriptor", "checkOverloadsInClass", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "nestedClassConstructors", "checkOverloadsInPackage", "members", "getPossibleRedeclarationGroups", "isPrivate", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isSynthesized", "findRedeclarations", "isConstructorsOfDifferentRedeclaredClasses", "member1", "member2", "isTopLevelMainInDifferentFiles", "isExpectDeclarationAndDefinition", "declaration", "definition", "isDefinitionsForDifferentPlatforms", "reportRedeclarations", "redeclarations", "frontend"})
@SourceDebugExtension(value={"SMAP\nOverloadResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverloadResolver.kt\norg/jetbrains/kotlin/resolve/OverloadResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 diagnosticUtils.kt\norg/jetbrains/kotlin/diagnostics/DiagnosticUtilsKt\n*L\n1#1,336:1\n158#1,32:337\n191#1:371\n188#1,7:373\n167#1,3:380\n158#1,32:383\n191#1:417\n188#1,7:419\n167#1,3:426\n176#1,14:429\n191#1:445\n188#1,7:447\n774#2:369\n865#2:370\n866#2:372\n774#2:415\n865#2:416\n866#2:418\n774#2:443\n865#2:444\n866#2:446\n774#2:454\n865#2,2:455\n1863#2:457\n1864#2:465\n774#2:466\n865#2,2:467\n1485#2:469\n1510#2,3:470\n1513#2,3:480\n1755#2,3:483\n381#3,7:458\n381#3,7:473\n163#4,4:486\n*S KotlinDebug\n*F\n+ 1 OverloadResolver.kt\norg/jetbrains/kotlin/resolve/OverloadResolver\n*L\n123#1:337,32\n123#1:371\n123#1:373,7\n123#1:380,3\n143#1:383,32\n143#1:417\n143#1:419,7\n143#1:426,3\n166#1:429,14\n166#1:445\n166#1:447,7\n123#1:369\n123#1:370\n123#1:372\n143#1:415\n143#1:416\n143#1:418\n166#1:443\n166#1:444\n166#1:446\n189#1:454\n189#1:455,2\n223#1:457\n223#1:465\n240#1:466\n240#1:467,2\n242#1:469\n242#1:470,3\n242#1:480,3\n247#1:483,3\n224#1:458,7\n242#1:473,7\n330#1:486,4\n*E\n"})
public final class OverloadResolver {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final OverloadFilter overloadFilter;
    @NotNull
    private final OverloadChecker overloadChecker;
    @NotNull
    private final ConflictingOverloadsDispatcher errorDispatcher;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final MainFunctionDetector mainFunctionDetector;

    public OverloadResolver(@NotNull BindingTrace trace, @NotNull OverloadFilter overloadFilter, @NotNull OverloadChecker overloadChecker, @NotNull ConflictingOverloadsDispatcher errorDispatcher, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull MainFunctionDetector.Factory mainFunctionDetectorFactory) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(overloadFilter, "overloadFilter");
        Intrinsics.checkNotNullParameter(overloadChecker, "overloadChecker");
        Intrinsics.checkNotNullParameter(errorDispatcher, "errorDispatcher");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(mainFunctionDetectorFactory, "mainFunctionDetectorFactory");
        this.trace = trace;
        this.overloadFilter = overloadFilter;
        this.overloadChecker = overloadChecker;
        this.errorDispatcher = errorDispatcher;
        this.languageVersionSettings = languageVersionSettings;
        this.mainFunctionDetector = mainFunctionDetectorFactory.createMainFunctionDetector(this.trace, this.languageVersionSettings);
    }

    public final void checkOverloads(@NotNull BodiesResolveContext c) {
        Intrinsics.checkNotNullParameter(c, "c");
        MultiMap<ClassDescriptor, FunctionDescriptor> inClasses = this.findConstructorsInNestedClassesAndTypeAliases(c);
        for (ClassDescriptorWithResolutionScopes value2 : c.getDeclaredClasses().values()) {
            Intrinsics.checkNotNull(value2);
            Collection<FunctionDescriptor> collection = inClasses.get(value2);
            Intrinsics.checkNotNullExpressionValue(collection, "get(...)");
            this.checkOverloadsInClass(value2, collection);
        }
        this.checkOverloadsInPackages(c);
    }

    private final MultiMap<ClassDescriptor, FunctionDescriptor> findConstructorsInNestedClassesAndTypeAliases(BodiesResolveContext c) {
        DeclarationDescriptor containingDeclaration;
        MultiMap<ClassDescriptor, FunctionDescriptor> multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue(multiMap, "create(...)");
        MultiMap<ClassDescriptor, FunctionDescriptor> constructorsByOuterClass = multiMap;
        for (ClassDescriptorWithResolutionScopes klass : c.getDeclaredClasses().values()) {
            if (klass.getKind().isSingleton() || klass.getName().isSpecial()) continue;
            Intrinsics.checkNotNullExpressionValue(klass.getContainingDeclaration(), "getContainingDeclaration(...)");
            if (containingDeclaration instanceof ScriptDescriptor) continue;
            if (containingDeclaration instanceof ClassDescriptor) {
                constructorsByOuterClass.putValues((ClassDescriptor)containingDeclaration, klass.getConstructors());
                continue;
            }
            if (containingDeclaration instanceof FunctionDescriptor || containingDeclaration instanceof PropertyDescriptor || containingDeclaration instanceof PackageFragmentDescriptor) continue;
            throw new IllegalStateException("Illegal class container: " + containingDeclaration);
        }
        for (TypeAliasDescriptor typeAlias : c.getTypeAliases().values()) {
            Intrinsics.checkNotNullExpressionValue(typeAlias.getContainingDeclaration(), "getContainingDeclaration(...)");
            if (!(containingDeclaration instanceof ClassDescriptor)) continue;
            constructorsByOuterClass.putValues((ClassDescriptor)containingDeclaration, typeAlias.getConstructors());
        }
        return constructorsByOuterClass;
    }

    private final void checkOverloadsInPackages(BodiesResolveContext c) {
        MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot> membersByName = this.groupModulePackageMembersByFqName(c, this.overloadFilter);
        for (Map.Entry<FqNameUnsafe, Collection<DeclarationDescriptorNonRoot>> e : membersByName.entrySet()) {
            Collection<DeclarationDescriptorNonRoot> collection = e.getValue();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-value>(...)");
            this.checkOverloadsInPackage(collection);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot> groupModulePackageMembersByFqName(BodiesResolveContext c, OverloadFilter overloadFilter) {
        Object possibleOverloads$iv$iv;
        ClassifierDescriptor classifier2;
        Name name;
        MemberScope scope2;
        MemberScope containingPackageScope$iv$iv;
        ModuleDescriptor containingModule$iv$iv;
        DeclarationDescriptor containingPackage$iv$iv;
        boolean $i$f$getModulePackageMembersWithSameName;
        OverloadResolver this_$iv$iv;
        OverloadResolver this_$iv;
        FqNameUnsafe descriptorFQN$iv;
        Collection<PropertyDescriptor> interestingDescriptors$iv;
        MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot> packageMembersByName = new MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot>();
        OverloadResolver overloadResolver = this;
        Collection<SimpleFunctionDescriptor> collection = c.getFunctions().values();
        Intrinsics.checkNotNull(collection, "null cannot be cast to non-null type kotlin.collections.Collection<org.jetbrains.kotlin.descriptors.DeclarationDescriptor>");
        Collection collection2 = CollectionsKt.plus((Collection)CollectionsKt.plus(collection, (Iterable)c.getDeclaredClasses().values()), (Iterable)c.getTypeAliases().values());
        boolean $i$f$collectModulePackageMembersWithSameName = false;
        HashSet<FqNameUnsafe> observedFQNs$iv = new HashSet<FqNameUnsafe>();
        for (DeclarationDescriptor declarationDescriptor : interestingDescriptors$iv) {
            Collection<DeclarationDescriptorNonRoot> collection3;
            if (!(declarationDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor)) continue;
            Intrinsics.checkNotNullExpressionValue(DescriptorUtils.getFqName(declarationDescriptor), "getFqName(...)");
            if (observedFQNs$iv.contains(descriptorFQN$iv)) continue;
            observedFQNs$iv.add(descriptorFQN$iv);
            this_$iv$iv = this_$iv;
            $i$f$getModulePackageMembersWithSameName = false;
            containingPackage$iv$iv = declarationDescriptor.getContainingDeclaration();
            if (!(containingPackage$iv$iv instanceof PackageFragmentDescriptor)) {
                throw new AssertionError((Object)(declarationDescriptor + " is not a top-level package member"));
            }
            if (DescriptorUtils.getContainingModuleOrNull(declarationDescriptor) == null) {
                DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
                if (declarationDescriptor2 instanceof CallableMemberDescriptor) {
                    collection3 = (Collection<ClassConstructorDescriptor>)CollectionsKt.listOf(declarationDescriptor);
                } else {
                    if (!(declarationDescriptor2 instanceof ClassDescriptor)) throw new AssertionError((Object)("Unexpected descriptor kind: " + declarationDescriptor));
                    Collection<ClassConstructorDescriptor> collection4 = ((ClassDescriptor)declarationDescriptor).getConstructors();
                    collection3 = collection4;
                    Intrinsics.checkNotNullExpressionValue(collection4, "getConstructors(...)");
                }
            } else {
                void $this$filterTo$iv$iv$iv$iv;
                Collection collection5;
                containingPackageScope$iv$iv = containingModule$iv$iv.getPackage(((PackageFragmentDescriptor)containingPackage$iv$iv).getFqName()).getMemberScope();
                Intrinsics.checkNotNullExpressionValue(declarationDescriptor.getName(), "getName(...)");
                scope2 = containingPackageScope$iv$iv;
                boolean bl = false;
                Collection functions2 = scope2.getContributedFunctions(name, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                ClassifierDescriptor classifierDescriptor = classifier2 = scope2.getContributedClassifier(name, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                if (classifierDescriptor instanceof ClassDescriptor) {
                    if (!((ClassDescriptor)classifier2).getKind().isSingleton()) {
                        Collection<ClassConstructorDescriptor> collection6 = ((ClassDescriptor)classifier2).getConstructors();
                        Intrinsics.checkNotNullExpressionValue(collection6, "getConstructors(...)");
                        collection5 = CollectionsKt.plus(functions2, (Iterable)collection6);
                    } else {
                        collection5 = functions2;
                    }
                } else {
                    collection5 = classifierDescriptor instanceof TypeAliasDescriptor ? (Collection)CollectionsKt.plus(functions2, (Iterable)((TypeAliasDescriptor)classifier2).getConstructors()) : functions2;
                }
                Iterable $this$filter$iv$iv$iv = collection5;
                boolean $i$f$filter2 = false;
                Iterable iterable = $this$filter$iv$iv$iv;
                Collection destination$iv$iv$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv) {
                    DeclarationDescriptorNonRoot it$iv$iv = (DeclarationDescriptorNonRoot)element$iv$iv$iv$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(DescriptorUtils.getContainingModule(it$iv$iv), containingModule$iv$iv)) continue;
                    destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                }
                possibleOverloads$iv$iv = (List)destination$iv$iv$iv$iv;
                collection3 = overloadFilter.filterPackageMemberOverloads((Collection)possibleOverloads$iv$iv);
            }
            Collection<ClassConstructorDescriptor> packageMembersWithSameName$iv = collection3;
            packageMembersByName.putValues(descriptorFQN$iv, packageMembersWithSameName$iv);
        }
        this_$iv = this;
        interestingDescriptors$iv = c.getProperties().values();
        $i$f$collectModulePackageMembersWithSameName = false;
        observedFQNs$iv = new HashSet();
        for (DeclarationDescriptor declarationDescriptor : interestingDescriptors$iv) {
            Collection<DeclarationDescriptorNonRoot> collection7;
            if (!(declarationDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor)) continue;
            Intrinsics.checkNotNullExpressionValue(DescriptorUtils.getFqName(declarationDescriptor), "getFqName(...)");
            if (observedFQNs$iv.contains(descriptorFQN$iv)) continue;
            observedFQNs$iv.add(descriptorFQN$iv);
            this_$iv$iv = this_$iv;
            $i$f$getModulePackageMembersWithSameName = false;
            containingPackage$iv$iv = declarationDescriptor.getContainingDeclaration();
            if (!(containingPackage$iv$iv instanceof PackageFragmentDescriptor)) {
                throw new AssertionError((Object)(declarationDescriptor + " is not a top-level package member"));
            }
            if (DescriptorUtils.getContainingModuleOrNull(declarationDescriptor) == null) {
                possibleOverloads$iv$iv = declarationDescriptor;
                if (possibleOverloads$iv$iv instanceof CallableMemberDescriptor) {
                    collection7 = (Collection<ClassConstructorDescriptor>)CollectionsKt.listOf(declarationDescriptor);
                } else {
                    if (!(possibleOverloads$iv$iv instanceof ClassDescriptor)) throw new AssertionError((Object)("Unexpected descriptor kind: " + declarationDescriptor));
                    Collection<ClassConstructorDescriptor> collection8 = ((ClassDescriptor)declarationDescriptor).getConstructors();
                    collection7 = collection8;
                    Intrinsics.checkNotNullExpressionValue(collection8, "getConstructors(...)");
                }
            } else {
                void $this$filterTo$iv$iv$iv$iv;
                containingPackageScope$iv$iv = containingModule$iv$iv.getPackage(((PackageFragmentDescriptor)containingPackage$iv$iv).getFqName()).getMemberScope();
                Intrinsics.checkNotNullExpressionValue(declarationDescriptor.getName(), "getName(...)");
                scope2 = containingPackageScope$iv$iv;
                boolean bl = false;
                Collection<? extends PropertyDescriptor> variables2 = scope2.getContributedVariables(name, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                classifier2 = scope2.getContributedClassifier(name, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                Iterable $this$filter$iv$iv$iv = CollectionsKt.plus(variables2, (Iterable)CollectionsKt.listOfNotNull(classifier2));
                boolean $i$f$filter = false;
                Iterable $i$f$filter2 = $this$filter$iv$iv$iv;
                Collection destination$iv$iv$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv) {
                    DeclarationDescriptorNonRoot it$iv$iv = (DeclarationDescriptorNonRoot)element$iv$iv$iv$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(DescriptorUtils.getContainingModule(it$iv$iv), containingModule$iv$iv)) continue;
                    destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                }
                possibleOverloads$iv$iv = (List)destination$iv$iv$iv$iv;
                collection7 = overloadFilter.filterPackageMemberOverloads((Collection)possibleOverloads$iv$iv);
            }
            Collection<ClassConstructorDescriptor> packageMembersWithSameName$iv = collection7;
            packageMembersByName.putValues(descriptorFQN$iv, packageMembersWithSameName$iv);
        }
        return packageMembersByName;
    }

    private final void checkOverloadsInClass(ClassDescriptorWithResolutionScopes classDescriptor, Collection<? extends FunctionDescriptor> nestedClassConstructors) {
        MultiMap<Name, CallableMemberDescriptor> multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue(multiMap, "create(...)");
        MultiMap<Name, CallableMemberDescriptor> functionsByName2 = multiMap;
        for (CallableMemberDescriptor callableMemberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            functionsByName2.putValue(callableMemberDescriptor.getName(), callableMemberDescriptor);
        }
        for (FunctionDescriptor functionDescriptor : nestedClassConstructors) {
            Name name;
            Intrinsics.checkNotNullExpressionValue(functionDescriptor.getContainingDeclaration().getName(), "getName(...)");
            functionsByName2.putValue(name, functionDescriptor);
        }
        for (Map.Entry entry : functionsByName2.entrySet()) {
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, "<get-value>(...)");
            this.checkOverloadsInClass((Collection)v);
        }
    }

    private final void checkOverloadsInPackage(Collection<? extends DeclarationDescriptorNonRoot> members2) {
        if (members2.size() == 1) {
            return;
        }
        LinkedHashMap redeclarationsMap = new LinkedHashMap();
        for (Collection<DeclarationDescriptorNonRoot> redeclarationGroup : this.getPossibleRedeclarationGroups(members2)) {
            Collection<DeclarationDescriptorNonRoot> redeclarations = this.findRedeclarations(redeclarationGroup);
            Iterable $this$forEach$iv = redeclarations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv;
                boolean bl = false;
                Map $this$getOrPut$iv = redeclarationsMap;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(it);
                if (value$iv == null) {
                    boolean bl2 = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(it, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).addAll(redeclarations);
            }
        }
        HashSet reported = new HashSet();
        for (Map.Entry entry : ((Map)redeclarationsMap).entrySet()) {
            DeclarationDescriptorNonRoot member = (DeclarationDescriptorNonRoot)entry.getKey();
            Set conflicting = (Set)entry.getValue();
            if (reported.contains(member)) continue;
            reported.addAll(conflicting);
            this.reportRedeclarations(conflicting);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Collection<DeclarationDescriptorNonRoot>> getPossibleRedeclarationGroups(Collection<? extends DeclarationDescriptorNonRoot> members2) {
        void $this$groupByTo$iv$iv;
        void $this$filterTo$iv$iv;
        ArrayList<Collection<Object>> result2 = new ArrayList<Collection<Object>>();
        Iterable $this$filter$iv = members2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv$iv;
            boolean bl = false;
            if (!(!this.isPrivate(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonPrivates = (List)destination$iv$iv;
        Iterable $this$groupBy$iv = members2;
        boolean $i$f$groupBy = false;
        destination$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv$iv;
            boolean bl = false;
            SourceFile key$iv$iv = DescriptorUtils.getContainingSourceFile(it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map bySourceFile = destination$iv$iv2;
        boolean hasGroupIncludingNonPrivateMembers = false;
        for (List membersInFile : bySourceFile.values()) {
            boolean bl;
            block9: {
                Iterable $this$any$iv = membersInFile;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv;
                        boolean bl3 = false;
                        if (!this.isPrivate(it)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            hasGroupIncludingNonPrivateMembers = true;
            Set group = SetsKt.plus((Set)new LinkedHashSet(nonPrivates), membersInFile);
            result2.add(group);
        }
        if (!hasGroupIncludingNonPrivateMembers && nonPrivates.size() > 1) {
            result2.add(nonPrivates);
        }
        return result2;
    }

    private final boolean isPrivate(DeclarationDescriptor $this$isPrivate) {
        return $this$isPrivate instanceof DeclarationDescriptorWithVisibility && DescriptorVisibilities.isPrivate(((DeclarationDescriptorWithVisibility)$this$isPrivate).getVisibility());
    }

    private final void checkOverloadsInClass(Collection<? extends CallableMemberDescriptor> members2) {
        if (members2.size() == 1) {
            return;
        }
        this.reportRedeclarations(this.findRedeclarations(members2));
    }

    private final boolean isSynthesized(DeclarationDescriptor $this$isSynthesized) {
        return $this$isSynthesized instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)$this$isSynthesized).getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED;
    }

    private final Collection<DeclarationDescriptorNonRoot> findRedeclarations(Collection<? extends DeclarationDescriptorNonRoot> members2) {
        LinkedHashSet<DeclarationDescriptorNonRoot> redeclarations = new LinkedHashSet<DeclarationDescriptorNonRoot>();
        for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot : members2) {
            if (this.isSynthesized(declarationDescriptorNonRoot)) continue;
            for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot2 : members2) {
                if (Intrinsics.areEqual(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isConstructorsOfDifferentRedeclaredClasses(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isTopLevelMainInDifferentFiles(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isDefinitionsForDifferentPlatforms(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isExpectDeclarationAndDefinition(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isExpectDeclarationAndDefinition(declarationDescriptorNonRoot2, declarationDescriptorNonRoot) || this.overloadChecker.isOverloadable(declarationDescriptorNonRoot, declarationDescriptorNonRoot2)) continue;
                redeclarations.add(declarationDescriptorNonRoot);
            }
        }
        return redeclarations;
    }

    private final boolean isConstructorsOfDifferentRedeclaredClasses(DeclarationDescriptor member1, DeclarationDescriptor member2) {
        if (!(member1 instanceof ConstructorDescriptor) || !(member2 instanceof ConstructorDescriptor)) {
            return false;
        }
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)member1).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(classifierDescriptorWithTypeParameters, "getContainingDeclaration(...)");
        ClassifierDescriptorWithTypeParameters parent1 = classifierDescriptorWithTypeParameters;
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters2 = ((ConstructorDescriptor)member2).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(classifierDescriptorWithTypeParameters2, "getContainingDeclaration(...)");
        ClassifierDescriptorWithTypeParameters parent2 = classifierDescriptorWithTypeParameters2;
        return parent1 != parent2 && Intrinsics.areEqual(parent1.getContainingDeclaration(), parent2.getContainingDeclaration());
    }

    private final boolean isTopLevelMainInDifferentFiles(DeclarationDescriptor member1, DeclarationDescriptor member2) {
        if (!MainFunctionDetector.isMain$default(this.mainFunctionDetector, member1, false, false, false, 14, null) || !MainFunctionDetector.isMain$default(this.mainFunctionDetector, member2, false, false, false, 14, null)) {
            return false;
        }
        KtFile file1 = DescriptorToSourceUtils.getContainingFile(member1);
        KtFile file2 = DescriptorToSourceUtils.getContainingFile(member2);
        return file1 == null || file2 == null || file1 != file2;
    }

    private final boolean isExpectDeclarationAndDefinition(DeclarationDescriptor declaration, DeclarationDescriptor definition) {
        return declaration instanceof MemberDescriptor && ((MemberDescriptor)declaration).isExpect() && definition instanceof MemberDescriptor && !((MemberDescriptor)definition).isExpect();
    }

    private final boolean isDefinitionsForDifferentPlatforms(DeclarationDescriptorNonRoot member1, DeclarationDescriptorNonRoot member2) {
        if (!(member1 instanceof MemberDescriptor) || !(member2 instanceof MemberDescriptor)) {
            return false;
        }
        return ((MemberDescriptor)member1).isActual() && ((MemberDescriptor)member2).isActual() && !Intrinsics.areEqual(DescriptorUtilsKt.getPlatform(member1), DescriptorUtilsKt.getPlatform(member2));
    }

    /*
     * WARNING - void declaration
     */
    private final void reportRedeclarations(Collection<? extends DeclarationDescriptorNonRoot> redeclarations) {
        if (redeclarations.isEmpty()) {
            return;
        }
        for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot : redeclarations) {
            void it;
            DiagnosticFactory1<PsiElement, Collection<DeclarationDescriptor>> diagnostic;
            PsiElement psiElement$iv;
            if (this.errorDispatcher.getDiagnostic(this.languageVersionSettings, declarationDescriptorNonRoot, redeclarations) == null) continue;
            BindingTrace trace$iv = this.trace;
            boolean $i$f$reportOnDeclaration = false;
            if (DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptorNonRoot) == null) continue;
            boolean bl = false;
            PsiElement psiElement = psiElement$iv;
            BindingTrace bindingTrace = trace$iv;
            boolean bl2 = false;
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = diagnostic.on((PsiElement)it, redeclarations);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
            bindingTrace.report(parametrizedDiagnostic);
        }
    }
}

