/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CoroutineSuspendCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
@SourceDebugExtension(value={"SMAP\ncoroutineCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 coroutineCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/CoroutineSuspendCallChecker\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,205:1\n125#2:206\n1251#3,2:207\n*S KotlinDebug\n*F\n+ 1 coroutineCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/CoroutineSuspendCallChecker\n*L\n76#1:206\n85#1:207,2\n*E\n"})
public final class CoroutineSuspendCallChecker
implements CallChecker {
    @NotNull
    public static final CoroutineSuspendCallChecker INSTANCE = new CoroutineSuspendCallChecker();

    private CoroutineSuspendCallChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Object descriptor2;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        Object obj = resolvedCall2.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, "getCandidateDescriptor(...)");
        Object obj2 = descriptor2 = obj;
        if (obj2 instanceof FunctionDescriptor) {
            if (!((FunctionDescriptor)descriptor2).isSuspend()) {
                return;
            }
        } else if (obj2 instanceof PropertyDescriptor) {
            if (!Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)descriptor2), CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_FQ_NAME())) {
                return;
            }
        } else {
            return;
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNull(ktElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        KtExpression callElement = (KtExpression)ktElement;
        FunctionDescriptor enclosingSuspendFunction = CoroutineCallCheckerKt.findEnclosingSuspendFunction(context);
        if (enclosingSuspendFunction != null) {
            if (!InlineUtil.checkNonLocalReturnUsage(enclosingSuspendFunction, callElement, context.getResolutionContext())) {
                boolean shouldReport = true;
                PsiFile containingFile = callElement.getContainingFile();
                if (containingFile instanceof KtCodeFragment) {
                    KtExpression c;
                    KtExpression ktExpression;
                    PsiElement psiElement = ((KtCodeFragment)containingFile).getContext();
                    if (psiElement != null) {
                        void $this$getParentOfType$iv;
                        PsiElement psiElement2 = psiElement;
                        boolean strict$iv = false;
                        boolean $i$f$getParentOfType = false;
                        ktExpression = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtExpression.class, strict$iv);
                    } else {
                        ktExpression = c = null;
                    }
                    if (c != null && InlineUtil.checkNonLocalReturnUsage(enclosingSuspendFunction, c, context.getResolutionContext())) {
                        shouldReport = false;
                    }
                }
                if (shouldReport) {
                    context.getTrace().report(Errors.NON_LOCAL_SUSPENSION_POINT.on(reportOn));
                }
            } else {
                boolean bl;
                block21: {
                    Sequence<HierarchicalScope> $this$any$iv = ScopeUtilsKt.getParentsWithSelf(context.getScope());
                    boolean $i$f$any = false;
                    Iterator<HierarchicalScope> iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        HierarchicalScope element$iv;
                        HierarchicalScope it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (!CoroutineCallCheckerKt.access$isScopeForDefaultParameterValuesOf(it, enclosingSuspendFunction)) continue;
                        bl = true;
                        break block21;
                    }
                    bl = false;
                }
                if (bl) {
                    context.getTrace().report(Errors.UNSUPPORTED.on(reportOn, "suspend function calls in a context of default parameter value"));
                }
            }
            context.getTrace().record(BindingContext.ENCLOSING_SUSPEND_FUNCTION_FOR_SUSPEND_FUNCTION_CALL, resolvedCall2.getCall(), enclosingSuspendFunction);
            CoroutineCallCheckerKt.access$checkRestrictsSuspension(enclosingSuspendFunction, resolvedCall2, reportOn, context);
        } else {
            Call call2 = resolvedCall2.getCall();
            Intrinsics.checkNotNullExpressionValue(call2, "getCall(...)");
            if (!CallUtilKt.isCallableReference(call2)) {
                CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)descriptor2;
                if (callableMemberDescriptor instanceof FunctionDescriptor) {
                    context.getTrace().report(Errors.ILLEGAL_SUSPEND_FUNCTION_CALL.on(reportOn, (CallableDescriptor)resolvedCall2.getCandidateDescriptor()));
                } else if (callableMemberDescriptor instanceof PropertyDescriptor) {
                    context.getTrace().report(Errors.ILLEGAL_SUSPEND_PROPERTY_ACCESS.on(reportOn, (CallableDescriptor)resolvedCall2.getCandidateDescriptor()));
                }
            }
        }
    }
}

