/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.InlineChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\"\u0010\u0004\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/InlineCheckerWrapper;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "checkersCache", "Ljava/lang/ref/WeakReference;", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "getChecker", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "frontend"})
@SourceDebugExtension(value={"SMAP\nInlineCheckerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCheckerWrapper.kt\norg/jetbrains/kotlin/resolve/calls/checkers/InlineCheckerWrapper\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,50:1\n381#2,7:51\n*S KotlinDebug\n*F\n+ 1 InlineCheckerWrapper.kt\norg/jetbrains/kotlin/resolve/calls/checkers/InlineCheckerWrapper\n*L\n47#1:51,7\n*E\n"})
public final class InlineCheckerWrapper
implements CallChecker {
    @Nullable
    private WeakReference<Map<DeclarationDescriptor, CallChecker>> checkersCache;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        if (context.isAnnotationContext()) {
            return;
        }
        for (DeclarationDescriptor parentDescriptor = context.getScope().getOwnerDescriptor(); parentDescriptor != null; parentDescriptor = parentDescriptor.getContainingDeclaration()) {
            if (!InlineUtil.isInline(parentDescriptor)) continue;
            CallChecker checker = this.getChecker((FunctionDescriptor)parentDescriptor);
            checker.check(resolvedCall2, reportOn, context);
        }
    }

    private final CallChecker getChecker(FunctionDescriptor descriptor2) {
        Object object;
        WeakReference<Object> weakReference;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> map;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> weakReference2 = this.checkersCache;
        if (weakReference2 == null || (weakReference2 = (Map)weakReference2.get()) == null) {
            weakReference2 = map = (Map)new HashMap();
        }
        if ((weakReference = this.checkersCache) == null) {
            weakReference = new WeakReference<Object>(map);
        }
        this.checkersCache = weakReference;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> $this$getOrPut$iv = map;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl = false;
            CallChecker answer$iv = new InlineChecker(descriptor2);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CallChecker)object;
    }
}

