/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtImportInfo;
import org.jetbrains.kotlin.resolve.lazy.IndexedImports;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ9\u0010\u000e\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00018\u00008\u0000 \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0013R \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u00000\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/lazy/ExplicitImportsIndexed;", "I", "Lorg/jetbrains/kotlin/psi/KtImportInfo;", "Lorg/jetbrains/kotlin/resolve/lazy/IndexedImports;", "imports", "", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "<init>", "([Lorg/jetbrains/kotlin/psi/KtImportInfo;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "nameToDirectives", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "Lcom/google/common/collect/ListMultimap;", "Lorg/jetbrains/kotlin/name/Name;", "importsForName", "", "kotlin.jvm.PlatformType", "", "name", "(Lorg/jetbrains/kotlin/name/Name;)Ljava/util/List;", "frontend"})
public final class ExplicitImportsIndexed<I extends KtImportInfo>
extends IndexedImports<I> {
    @NotNull
    private final NotNullLazyValue<ListMultimap<Name, I>> nameToDirectives;

    public ExplicitImportsIndexed(@NotNull I[] imports, @NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter(imports, "imports");
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        super(imports);
        this.nameToDirectives = storageManager.createLazyValue(() -> ExplicitImportsIndexed.nameToDirectives$lambda$0(imports));
    }

    @Override
    public List<I> importsForName(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return ((ListMultimap)this.nameToDirectives.invoke()).get(name);
    }

    private static final ImmutableListMultimap nameToDirectives$lambda$0(KtImportInfo[] $imports) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (KtImportInfo directive : $imports) {
            Name importedName;
            if (directive.getImportedName() == null) continue;
            builder.put(importedName, directive);
        }
        return builder.build();
    }
}

