/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.SonarRuntime;
import org.sonar.api.issue.impact.Severity;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rule.RuleScope;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.CleanCodeAttribute;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionAnnotationLoader;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.Version;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.BuiltInQualityProfileJsonLoader;
import org.sonarsource.analyzer.commons.EducationRuleLoader;
import org.sonarsource.analyzer.commons.JsonParser;
import org.sonarsource.analyzer.commons.Resources;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKeys;

public class RuleMetadataLoader {
    private static final String INVALID_PROPERTY_MESSAGE = "Invalid property: %s";
    private static final char RESOURCE_SEP = '/';
    private final String resourceFolder;
    private final Set<String> activatedByDefault;
    private final JsonParser jsonParser;
    private final SonarRuntime sonarRuntime;
    private final EducationRuleLoader educationRuleLoader;
    private static final String OWASP_2021 = "OWASP Top 10 2021";
    private static final String OWASP_2017 = "OWASP";
    private static final String PCI_DSS_PREFIX = "PCI DSS ";
    private static final String ASVS_PREFIX = "ASVS ";
    private static final String STIG_PREFIX = "STIG ";

    public RuleMetadataLoader(String resourceFolder, SonarRuntime sonarRuntime) {
        this(resourceFolder, Collections.emptySet(), sonarRuntime);
    }

    public RuleMetadataLoader(String resourceFolder, String defaultProfilePath, SonarRuntime sonarRuntime) {
        this(resourceFolder, BuiltInQualityProfileJsonLoader.loadActiveKeysFromJsonProfile(defaultProfilePath), sonarRuntime);
    }

    private RuleMetadataLoader(String resourceFolder, Set<String> activatedByDefault, SonarRuntime sonarRuntime) {
        this.resourceFolder = resourceFolder;
        this.jsonParser = new JsonParser();
        this.activatedByDefault = activatedByDefault;
        this.sonarRuntime = sonarRuntime;
        this.educationRuleLoader = new EducationRuleLoader(sonarRuntime);
    }

    public void addRulesByAnnotatedClass(RulesDefinition.NewRepository repository, List<Class<?>> ruleClasses) {
        for (Class<?> ruleClass : ruleClasses) {
            this.addRuleByAnnotatedClass(repository, ruleClass);
        }
    }

    public void addRulesByRuleKey(RulesDefinition.NewRepository repository, List<String> ruleKeys) {
        for (String ruleKey : ruleKeys) {
            this.addRuleByRuleKey(repository, ruleKey);
        }
    }

    private void addRuleByAnnotatedClass(RulesDefinition.NewRepository repository, Class<?> ruleClass) {
        RulesDefinition.NewRule rule = RuleMetadataLoader.addAnnotatedRule(repository, ruleClass);
        this.setDescriptionFromHtml(rule);
        this.setMetadataFromJson(rule);
        this.setDefaultActivation(rule);
    }

    private void setDefaultActivation(RulesDefinition.NewRule rule) {
        if (this.activatedByDefault.contains(rule.key())) {
            rule.setActivatedByDefault(true);
        }
    }

    private static RulesDefinition.NewRule addAnnotatedRule(RulesDefinition.NewRepository repository, Class<?> ruleClass) {
        Rule ruleAnnotation = (Rule)AnnotationUtils.getAnnotation(ruleClass, Rule.class);
        if (ruleAnnotation == null) {
            throw new IllegalStateException("No Rule annotation was found on " + ruleClass.getName());
        }
        String ruleKey = ruleAnnotation.key();
        if (ruleKey.isEmpty()) {
            throw new IllegalStateException("Empty key");
        }
        new RulesDefinitionAnnotationLoader().load((RulesDefinition.NewExtendedRepository)repository, new Class[]{ruleClass});
        RulesDefinition.NewRule rule = repository.rule(ruleKey);
        if (rule == null) {
            throw new IllegalStateException("Rule not found: " + ruleKey);
        }
        DeprecatedRuleKeys deprecatedRuleKeys = (DeprecatedRuleKeys)AnnotationUtils.getAnnotation(ruleClass, DeprecatedRuleKeys.class);
        if (deprecatedRuleKeys != null) {
            Arrays.stream(deprecatedRuleKeys.value()).forEach(deprecatedRuleKey -> RuleMetadataLoader.addDeprecatedRuleKey(repository, rule, deprecatedRuleKey));
        } else {
            DeprecatedRuleKey deprecatedRuleKey2 = (DeprecatedRuleKey)AnnotationUtils.getAnnotation(ruleClass, DeprecatedRuleKey.class);
            if (deprecatedRuleKey2 != null) {
                RuleMetadataLoader.addDeprecatedRuleKey(repository, rule, deprecatedRuleKey2);
            }
        }
        return rule;
    }

    private static void addDeprecatedRuleKey(RulesDefinition.NewRepository repository, RulesDefinition.NewRule rule, DeprecatedRuleKey deprecatedRuleKey) {
        String repoKey = deprecatedRuleKey.repositoryKey().isEmpty() ? repository.key() : deprecatedRuleKey.repositoryKey();
        rule.addDeprecatedRuleKey(repoKey, deprecatedRuleKey.ruleKey());
    }

    private void addRuleByRuleKey(RulesDefinition.NewRepository repository, String ruleKey) {
        if (ruleKey.isEmpty()) {
            throw new IllegalStateException("Empty key");
        }
        RulesDefinition.NewRule rule = repository.createRule(ruleKey);
        this.setDescriptionFromHtml(rule);
        this.setMetadataFromJson(rule);
        this.setDefaultActivation(rule);
    }

    private void setDescriptionFromHtml(RulesDefinition.NewRule rule) {
        String description2;
        String htmlPath = this.resourceFolder + "/" + rule.key() + ".html";
        try {
            description2 = Resources.toString(htmlPath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read resource: " + htmlPath, e);
        }
        description2 = this.educationRuleLoader.setEducationDescriptionFromHtml(rule, description2);
        rule.setHtmlDescription(description2);
    }

    private void setMetadataFromJson(RulesDefinition.NewRule rule) {
        Object securityStandards;
        Object code;
        Map<String, Object> ruleMetadata = this.getMetadata(rule.key());
        rule.setName(RuleMetadataLoader.getString(ruleMetadata, "title"));
        rule.setSeverity(RuleMetadataLoader.getUpperCaseString(ruleMetadata, "defaultSeverity"));
        String type2 = RuleMetadataLoader.getUpperCaseString(ruleMetadata, "type");
        rule.setType(RuleType.valueOf((String)type2));
        if (this.isSupported(10, 1) && (code = ruleMetadata.get("code")) != null) {
            this.setCodeAttributeFromJson(rule, (Map)code);
        }
        rule.setStatus(RuleStatus.valueOf((String)RuleMetadataLoader.getUpperCaseString(ruleMetadata, "status")));
        rule.setTags(RuleMetadataLoader.getStringArray(ruleMetadata, "tags"));
        RuleMetadataLoader.getScopeIfPresent(ruleMetadata, "scope").ifPresent(arg_0 -> ((RulesDefinition.NewRule)rule).setScope(arg_0));
        Object remediation = ruleMetadata.get("remediation");
        if (remediation != null) {
            RuleMetadataLoader.setRemediationFromJson(rule, (Map)remediation);
        }
        if ((securityStandards = ruleMetadata.get("securityStandards")) != null) {
            this.setSecurityStandardsFromJson(rule, (Map)securityStandards);
        }
        this.educationRuleLoader.setEducationMetadataFromJson(rule, ruleMetadata);
    }

    Map<String, Object> getMetadata(String ruleKey) {
        String jsonPath = this.resourceFolder + "/" + ruleKey + ".json";
        try {
            return this.jsonParser.parse(Resources.toString(jsonPath, StandardCharsets.UTF_8));
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Can't read resource: " + jsonPath, e);
        }
    }

    private void setCodeAttributeFromJson(RulesDefinition.NewRule rule, Map<String, Object> code) {
        String attribute = RuleMetadataLoader.getString(code, "attribute");
        rule.setCleanCodeAttribute(CleanCodeAttribute.valueOf((String)attribute));
        Map impacts = (Map)code.get("impacts");
        if (impacts == null || impacts.isEmpty()) {
            throw new IllegalStateException(String.format(INVALID_PROPERTY_MESSAGE, "impacts") + " for rule: " + rule.key());
        }
        impacts.forEach((softwareQuality, severity) -> rule.addDefaultImpact(SoftwareQuality.valueOf((String)softwareQuality), this.getCleanCodeTaxanomySeverity((String)severity)));
    }

    private Severity getCleanCodeTaxanomySeverity(String severity) {
        if (this.isSupported(10, 11)) {
            return Severity.valueOf((String)severity);
        }
        switch (severity) {
            case "INFO": {
                return Severity.LOW;
            }
            case "BLOCKER": {
                return Severity.HIGH;
            }
        }
        return Severity.valueOf((String)severity);
    }

    private void setSecurityStandardsFromJson(RulesDefinition.NewRule rule, Map<String, Object> securityStandards) {
        if (securityStandards.get("CWE") != null) {
            rule.addCwe(RuleMetadataLoader.getIntArray(securityStandards, "CWE"));
        }
        this.addOwasp(rule, securityStandards);
        this.addPciDss(rule, securityStandards);
        this.addOwaspAsvs(rule, securityStandards);
        this.addStig(rule, securityStandards);
    }

    private void addOwasp(RulesDefinition.NewRule rule, Map<String, Object> securityStandards) {
        boolean isOwaspByVersionSupported = this.isSupported(9, 3);
        for (String standard : RuleMetadataLoader.getStringArray(securityStandards, OWASP_2017)) {
            if (isOwaspByVersionSupported) {
                rule.addOwaspTop10(RulesDefinition.OwaspTop10Version.Y2017, new RulesDefinition.OwaspTop10[]{RulesDefinition.OwaspTop10.valueOf((String)standard)});
                continue;
            }
            rule.addOwaspTop10(new RulesDefinition.OwaspTop10[]{RulesDefinition.OwaspTop10.valueOf((String)standard)});
        }
        if (isOwaspByVersionSupported) {
            for (String standard : RuleMetadataLoader.getStringArray(securityStandards, OWASP_2021)) {
                rule.addOwaspTop10(RulesDefinition.OwaspTop10Version.Y2021, new RulesDefinition.OwaspTop10[]{RulesDefinition.OwaspTop10.valueOf((String)standard)});
            }
        }
    }

    private void addPciDss(RulesDefinition.NewRule rule, Map<String, Object> securityStandards) {
        if (!this.isSupported(9, 5)) {
            return;
        }
        for (RulesDefinition.PciDssVersion pciDssVersion : RulesDefinition.PciDssVersion.values()) {
            String pciDssKey = PCI_DSS_PREFIX + pciDssVersion.label();
            rule.addPciDss(pciDssVersion, RuleMetadataLoader.getStringArray(securityStandards, pciDssKey));
        }
    }

    private void addOwaspAsvs(RulesDefinition.NewRule rule, Map<String, Object> securityStandards) {
        if (!this.isSupported(9, 9)) {
            return;
        }
        for (RulesDefinition.OwaspAsvsVersion asvsVersion : RulesDefinition.OwaspAsvsVersion.values()) {
            String asvsKey = ASVS_PREFIX + asvsVersion.label();
            rule.addOwaspAsvs(asvsVersion, RuleMetadataLoader.getStringArray(securityStandards, asvsKey));
        }
    }

    private void addStig(RulesDefinition.NewRule rule, Map<String, Object> securityStandards) {
        if (!this.isSupported(10, 10)) {
            return;
        }
        for (RulesDefinition.StigVersion stigVersion : RulesDefinition.StigVersion.values()) {
            String stigKey = STIG_PREFIX + stigVersion.label();
            rule.addStig(stigVersion, RuleMetadataLoader.getStringArray(securityStandards, stigKey));
        }
    }

    private boolean isSupported(int minMajor, int minMinor) {
        return this.sonarRuntime.getApiVersion().isGreaterThanOrEqual(Version.create((int)minMajor, (int)minMinor));
    }

    private static void setRemediationFromJson(RulesDefinition.NewRule rule, Map<String, Object> remediation) {
        String func = RuleMetadataLoader.getString(remediation, "func");
        RulesDefinition.DebtRemediationFunctions remediationBuilder = rule.debtRemediationFunctions();
        if (func.startsWith("Constant")) {
            String constantCost = RuleMetadataLoader.getString(remediation, "constantCost");
            rule.setDebtRemediationFunction(remediationBuilder.constantPerIssue(constantCost.replace("mn", "min")));
        } else if ("Linear".equals(func)) {
            String linearFactor = RuleMetadataLoader.getString(remediation, "linearFactor");
            rule.setDebtRemediationFunction(remediationBuilder.linear(linearFactor.replace("mn", "min")));
        } else {
            String linearFactor = RuleMetadataLoader.getString(remediation, "linearFactor");
            String linearOffset = RuleMetadataLoader.getString(remediation, "linearOffset");
            rule.setDebtRemediationFunction(remediationBuilder.linearWithOffset(linearFactor.replace("mn", "min"), linearOffset.replace("mn", "min")));
        }
        if (remediation.get("linearDesc") != null) {
            rule.setGapDescription(RuleMetadataLoader.getString(remediation, "linearDesc"));
        }
    }

    private static String getUpperCaseString(Map<String, Object> map, String propertyName) {
        return RuleMetadataLoader.getString(map, propertyName).toUpperCase(Locale.ROOT);
    }

    private static String getString(Map<String, Object> map, String propertyName) {
        Object propertyValue = map.get(propertyName);
        if (!(propertyValue instanceof String)) {
            throw new IllegalStateException(String.format(INVALID_PROPERTY_MESSAGE, propertyName));
        }
        return (String)propertyValue;
    }

    static String[] getStringArray(Map<String, Object> map, String propertyName) {
        Object propertyValue = map.get(propertyName);
        if (propertyValue == null) {
            return new String[0];
        }
        if (!(propertyValue instanceof List)) {
            throw new IllegalStateException(String.format(INVALID_PROPERTY_MESSAGE, propertyName));
        }
        return ((List)propertyValue).toArray(new String[0]);
    }

    static Optional<RuleScope> getScopeIfPresent(Map<String, Object> map, String propertyName) {
        Object propertyValue = map.get(propertyName);
        return Optional.ofNullable(propertyValue).filter(String.class::isInstance).map(value2 -> ((String)value2).toUpperCase(Locale.ROOT)).map(scope2 -> "TESTS".equals(scope2) ? "TEST" : scope2).map(RuleScope::valueOf);
    }

    private static int[] getIntArray(Map<String, Object> map, String propertyName) {
        Object propertyValue = map.get(propertyName);
        if (!(propertyValue instanceof List)) {
            throw new IllegalStateException(String.format(INVALID_PROPERTY_MESSAGE, propertyName));
        }
        return ((List)propertyValue).stream().mapToInt(Number::intValue).toArray();
    }
}

