/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.api.frontend;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonarsource.analyzer.commons.recognizers.CodeRecognizer;
import org.sonarsource.kotlin.api.frontend.Environment;
import org.sonarsource.kotlin.api.frontend.KotlinCodeVerifier$parsingIsSuccessful$;
import org.sonarsource.kotlin.api.frontend.KotlinFootprint;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/sonarsource/kotlin/api/frontend/KotlinCodeVerifier;", "", "<init>", "()V", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "environment", "Lorg/sonarsource/kotlin/api/frontend/Environment;", "codeRecognizer", "Lorg/sonarsource/analyzer/commons/recognizers/CodeRecognizer;", "KDOC_TAGS", "", "", "containsCode", "", "content", "parsingIsSuccessful", "isKDoc", "isNonCodeParsedAsCode", "tree", "Lcom/intellij/psi/PsiFile;", "isInfixNotation", "element", "Lcom/intellij/psi/PsiElement;", "sonar-kotlin-api"})
@SourceDebugExtension(value={"SMAP\nKotlinCodeVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCodeVerifier.kt\norg/sonarsource/kotlin/api/frontend/KotlinCodeVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,156:1\n774#2:157\n865#2,2:158\n1755#2,3:173\n1#3:160\n276#4,11:161\n299#4:172\n12371#5,2:176\n*S KotlinDebug\n*F\n+ 1 KotlinCodeVerifier.kt\norg/sonarsource/kotlin/api/frontend/KotlinCodeVerifier\n*L\n62#1:157\n62#1:158,2\n75#1:173,3\n70#1:161,11\n70#1:172\n80#1:176,2\n*E\n"})
public final class KotlinCodeVerifier {
    @NotNull
    public static final KotlinCodeVerifier INSTANCE = new KotlinCodeVerifier();
    @NotNull
    private static final Disposable disposable;
    @NotNull
    private static final Environment environment;
    @NotNull
    private static final CodeRecognizer codeRecognizer;
    @NotNull
    private static final List<String> KDOC_TAGS;

    private KotlinCodeVerifier() {
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsCode(@NotNull String content) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(content, "content");
        Object object = ((Object)StringsKt.trim((CharSequence)content)).toString();
        Regex regex = new Regex("\\w+");
        int n = 0;
        Iterable $this$filter$iv = regex.split((CharSequence)object, n);
        boolean $i$f$filter = false;
        Object object2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank(it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object = (List)destination$iv$iv;
        int n2 = 0;
        object2 = object.iterator();
        while (object2.hasNext()) {
            void it;
            Object e = object2.next();
            String $i$f$filterTo2 = (String)e;
            int n3 = n2;
            boolean bl = false;
            int n4 = ((Object)StringsKt.trim((CharSequence)it)).toString().length();
            n2 = n3 + n4;
        }
        int words = n2;
        return words > 2 && !this.isKDoc(content) && codeRecognizer.isLineOfCode(content) && this.parsingIsSuccessful(content);
    }

    private final boolean parsingIsSuccessful(String content) {
        boolean bl;
        try {
            String wrappedContent = "fun function () { " + content + " }";
            KtFile ktFile = environment.getKtPsiFactory().createFile(wrappedContent);
            PsiElement $this$findDescendantOfType_u24default$iv = ktFile;
            Function1 predicate$iv = parsingIsSuccessful$$inlined$findDescendantOfType$default$1.INSTANCE;
            boolean $i$f$findDescendantOfType = false;
            PsiElement $this$findDescendantOfType$iv$iv = $this$findDescendantOfType_u24default$iv;
            boolean $i$f$findDescendantOfType2 = false;
            PsiUtilsKt.checkDecompiledText($this$findDescendantOfType$iv$iv);
            Ref.ObjectRef result$iv$iv = new Ref.ObjectRef();
            $this$findDescendantOfType$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Ref.ObjectRef $result;
                {
                    this.$predicate = $predicate;
                    this.$result = $result;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    if (element instanceof PsiErrorElement && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                        this.$result.element = element;
                        this.stopWalking();
                        return;
                    }
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                }
            });
            bl = (PsiElement)result$iv$iv.element == null && !this.isNonCodeParsedAsCode(ktFile);
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private final boolean isKDoc(String content) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = KDOC_TAGS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string2 = content.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                    if (!StringsKt.contains$default((CharSequence)string2, it, false, 2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isNonCodeParsedAsCode(PsiFile tree) {
        boolean bl;
        block1: {
            PsiElement[] elements = tree.getLastChild().getLastChild().getChildren();
            boolean bl2 = false;
            Intrinsics.checkNotNull(elements);
            PsiElement[] $this$all$iv = elements;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                PsiElement element$iv;
                PsiElement it = element$iv = $this$all$iv[i];
                boolean bl3 = false;
                Intrinsics.checkNotNull(it);
                if (INSTANCE.isInfixNotation(it)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInfixNotation(PsiElement element) {
        if (!(element instanceof KtBinaryExpression)) return false;
        PsiElement[] binaryExprChildren = ((KtBinaryExpression)element).getChildren();
        boolean bl = false;
        if (binaryExprChildren.length != 3) return false;
        if (!(binaryExprChildren[1] instanceof KtOperationReferenceExpression)) return false;
        return true;
    }

    static {
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue(disposable, "newDisposable(...)");
        KotlinCodeVerifier.disposable = disposable;
        environment = new Environment(KotlinCodeVerifier.disposable, CollectionsKt.emptyList(), LanguageVersion.LATEST_STABLE, null, false, 24, null);
        codeRecognizer = new CodeRecognizer(0.9, KotlinFootprint.INSTANCE);
        String[] stringArray = new String[]{"@param", "@return", "@constructor", "@receiver", "@property", "@throws", "@exception", "@sample", "@see", "@author", "@since", "@suppress", "`"};
        KDOC_TAGS = CollectionsKt.listOf(stringArray);
    }
}

