/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.api.frontend;

import com.intellij.openapi.Disposable;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.environment.UtilKt;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.NoScopeRecordCliBindingTrace;
import org.jetbrains.kotlin.cli.jvm.compiler.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.MutableDiagnosticsWithSuppression;
import org.sonarsource.kotlin.api.frontend.KotlinCoreEnvironmentToolsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\u0007\u001a$\u0010\u000f\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nH\u0002\u001a\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0017H\u0002\u00a8\u0006\u001a"}, d2={"kotlinCoreEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "disposable", "Lcom/intellij/openapi/Disposable;", "analyzeAndGetBindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "env", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "transferDiagnostics", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "bindingContext", "compilerConfiguration", "classpath", "", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "classpathRoots", "Ljava/io/File;", "isJar", "", "sonar-kotlin-api"})
@SourceDebugExtension(value={"SMAP\nKotlinCoreEnvironmentTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCoreEnvironmentTools.kt\norg/sonarsource/kotlin/api/frontend/KotlinCoreEnvironmentToolsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1557#2:160\n1628#2,3:161\n774#2:164\n865#2,2:165\n*S KotlinDebug\n*F\n+ 1 KotlinCoreEnvironmentTools.kt\norg/sonarsource/kotlin/api/frontend/KotlinCoreEnvironmentToolsKt\n*L\n152#1:160\n152#1:161,3\n152#1:164\n152#1:165,2\n*E\n"})
public final class KotlinCoreEnvironmentToolsKt {
    @NotNull
    public static final KotlinCoreEnvironment kotlinCoreEnvironment(@NotNull CompilerConfiguration configuration, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Intrinsics.checkNotNullParameter(disposable, "disposable");
        UtilKt.setIdeaIoUseFallback();
        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.Companion.getNONE());
        configuration.put(CommonConfigurationKeys.MODULE_NAME, "sonar-kotlin-ng");
        return KotlinCoreEnvironment.Companion.createForProduction(disposable, configuration, EnvironmentConfigFiles.JVM_CONFIG_FILES);
    }

    @NotNull
    public static final BindingContext analyzeAndGetBindingContext(@NotNull KotlinCoreEnvironment env, @NotNull List<? extends KtFile> ktFiles) {
        Intrinsics.checkNotNullParameter(env, "env");
        Intrinsics.checkNotNullParameter(ktFiles, "ktFiles");
        AnalyzerWithCompilerReport analyzer2 = new AnalyzerWithCompilerReport(MessageCollector.Companion.getNONE(), CommonConfigurationKeysKt.getLanguageVersionSettings(env.getConfiguration()), false);
        analyzer2.analyzeAndReport((Collection<? extends KtFile>)ktFiles, () -> KotlinCoreEnvironmentToolsKt.analyzeAndGetBindingContext$lambda$0(env, ktFiles));
        return analyzer2.getAnalysisResult().getBindingContext();
    }

    @NotNull
    public static final List<Diagnostic> transferDiagnostics(@NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Diagnostics diagnostics = bindingContext.getDiagnostics();
        Intrinsics.checkNotNullExpressionValue(diagnostics, "getDiagnostics(...)");
        Diagnostics diagnostics2 = diagnostics;
        List<Diagnostic> diagnosticsList = CollectionsKt.toList(diagnostics2.noSuppression());
        if (diagnostics2 instanceof MutableDiagnosticsWithSuppression) {
            ((MutableDiagnosticsWithSuppression)diagnostics2).clear();
        } else if (!(diagnostics2 == BindingContext.EMPTY.getDiagnostics())) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        return diagnosticsList;
    }

    @NotNull
    public static final CompilerConfiguration compilerConfiguration(@NotNull List<String> classpath, @NotNull LanguageVersion languageVersion, @NotNull JvmTarget jvmTarget) {
        CompilerConfiguration compilerConfiguration;
        Intrinsics.checkNotNullParameter(classpath, "classpath");
        Intrinsics.checkNotNullParameter(languageVersion, "languageVersion");
        Intrinsics.checkNotNullParameter(jvmTarget, "jvmTarget");
        LanguageVersionSettingsImpl versionSettings = new LanguageVersionSettingsImpl(languageVersion, ApiVersion.Companion.createByLanguageVersion(languageVersion), null, null, 12, null);
        CompilerConfiguration $this$compilerConfiguration_u24lambda_u241 = compilerConfiguration = new CompilerConfiguration();
        boolean bl = false;
        $this$compilerConfiguration_u24lambda_u241.put(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS, versionSettings);
        $this$compilerConfiguration_u24lambda_u241.put(JVMConfigurationKeys.JVM_TARGET, jvmTarget);
        $this$compilerConfiguration_u24lambda_u241.put(JVMConfigurationKeys.JDK_HOME, new File(System.getProperty("java.home")));
        JvmContentRootsKt.addJvmClasspathRoots($this$compilerConfiguration_u24lambda_u241, KotlinCoreEnvironmentToolsKt.classpathRoots(classpath));
        return compilerConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<File> classpathRoots(List<String> classpath) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = classpath;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean $i$f$classpathRoots$stub_for_inlining = false;
            boolean bl = false;
            collection.add(new File((String)p0));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!(it.isDirectory() || KotlinCoreEnvironmentToolsKt.isJar(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isJar(File $this$isJar) {
        boolean bl;
        if (!$this$isJar.isFile()) return false;
        Closeable closeable = new FileInputStream($this$isJar);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl2 = false;
            int header = it.read() << 24 | it.read() << 16 | it.read() << 8 | it.read();
            bl = header == 1347093252;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        if (!bl) return false;
        return true;
    }

    private static final AnalysisResult analyzeAndGetBindingContext$lambda$0(KotlinCoreEnvironment $env, List $ktFiles) {
        return TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration$default($env.getProject(), $ktFiles, new NoScopeRecordCliBindingTrace($env.getProject()), $env.getConfiguration(), new Function1<GlobalSearchScope, JvmPackagePartProvider>((Object)$env){

            public final JvmPackagePartProvider invoke(GlobalSearchScope p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((KotlinCoreEnvironment)this.receiver).createPackagePartProvider(p0);
            }
        }, analyzeAndGetBindingContext.1.2.INSTANCE, null, null, null, null, null, 1984, null);
    }
}

