/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.api.sensors;

import com.intellij.openapi.Disposable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.slf4j.Logger;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonarsource.kotlin.api.common.ConstantsKt;
import org.sonarsource.kotlin.api.frontend.Environment;
import org.sonarsource.kotlin.api.frontend.ParseException;
import org.sonarsource.kotlin.api.logging.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"EMPTY_FILE_CONTENT_PATTERN", "Lkotlin/text/Regex;", "environment", "Lorg/sonarsource/kotlin/api/frontend/Environment;", "disposer", "Lcom/intellij/openapi/Disposable;", "sensorContext", "Lorg/sonar/api/batch/sensor/SensorContext;", "logger", "Lorg/slf4j/Logger;", "determineKotlinLanguageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "toParseException", "Lorg/sonarsource/kotlin/api/frontend/ParseException;", "action", "", "inputFile", "Lorg/sonar/api/batch/fs/InputFile;", "cause", "", "sonar-kotlin-api"})
@SourceDebugExtension(value={"SMAP\nAbstractKotlinSensorExecuteContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKotlinSensorExecuteContext.kt\norg/sonarsource/kotlin/api/sensors/AbstractKotlinSensorExecuteContextKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1#2:174\n*E\n"})
public final class AbstractKotlinSensorExecuteContextKt {
    @NotNull
    private static final Regex EMPTY_FILE_CONTENT_PATTERN = new Regex("\\s*+");

    @NotNull
    public static final Environment environment(@NotNull Disposable disposer, @NotNull SensorContext sensorContext, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(disposer, "disposer");
        Intrinsics.checkNotNullParameter(sensorContext, "sensorContext");
        Intrinsics.checkNotNullParameter(logger, "logger");
        String[] stringArray = sensorContext.config().getStringArray("sonar.java.binaries");
        Intrinsics.checkNotNullExpressionValue(stringArray, "getStringArray(...)");
        Collection collection = ArraysKt.toList((Object[])stringArray);
        String[] stringArray2 = sensorContext.config().getStringArray("sonar.java.libraries");
        Intrinsics.checkNotNullExpressionValue(stringArray2, "getStringArray(...)");
        return new Environment(disposer, CollectionsKt.plus(collection, (Iterable)ArraysKt.toList((Object[])stringArray2)), AbstractKotlinSensorExecuteContextKt.determineKotlinLanguageVersion(sensorContext, logger), null, false, 24, null);
    }

    private static final LanguageVersion determineKotlinLanguageVersion(SensorContext sensorContext, Logger logger) {
        LanguageVersion languageVersion;
        LanguageVersion languageVersion2 = sensorContext.config().get("sonar.kotlin.source.version").map(arg_0 -> AbstractKotlinSensorExecuteContextKt.determineKotlinLanguageVersion$lambda$2(arg_0 -> AbstractKotlinSensorExecuteContextKt.determineKotlinLanguageVersion$lambda$1(logger, arg_0), arg_0)).orElse(null);
        if (languageVersion2 == null) {
            languageVersion2 = ConstantsKt.getDEFAULT_KOTLIN_LANGUAGE_VERSION();
        }
        LanguageVersion it = languageVersion = languageVersion2;
        boolean bl = false;
        LoggerExtensionsKt.debug(logger, () -> AbstractKotlinSensorExecuteContextKt.determineKotlinLanguageVersion$lambda$4$lambda$3(it));
        return languageVersion;
    }

    private static final ParseException toParseException(String action, InputFile inputFile, Throwable cause) {
        ParseException parseException = cause instanceof ParseException ? (ParseException)cause : null;
        return new ParseException("Cannot " + action + " '" + inputFile + "': " + cause.getMessage(), (TextPointer)(parseException != null ? parseException.getPosition() : null), cause);
    }

    private static final LanguageVersion determineKotlinLanguageVersion$lambda$1(Logger $logger, String versionString) {
        LanguageVersion languageVersion;
        LanguageVersion langVersion = languageVersion = LanguageVersion.Companion.fromVersionString(versionString);
        boolean bl = false;
        if (langVersion == null) {
            Intrinsics.checkNotNull(versionString);
            if (!StringsKt.isBlank(versionString)) {
                $logger.warn("Failed to find Kotlin version '" + versionString + "'. Defaulting to " + ConstantsKt.getDEFAULT_KOTLIN_LANGUAGE_VERSION().getVersionString());
            }
        }
        return languageVersion;
    }

    private static final LanguageVersion determineKotlinLanguageVersion$lambda$2(Function1 $tmp0, Object p0) {
        return (LanguageVersion)$tmp0.invoke(p0);
    }

    private static final String determineKotlinLanguageVersion$lambda$4$lambda$3(LanguageVersion $it) {
        return "Using Kotlin " + $it.getVersionString() + " to parse source code";
    }

    public static final /* synthetic */ ParseException access$toParseException(String action, InputFile inputFile, Throwable cause) {
        return AbstractKotlinSensorExecuteContextKt.toParseException(action, inputFile, cause);
    }

    public static final /* synthetic */ Regex access$getEMPTY_FILE_CONTENT_PATTERN$p() {
        return EMPTY_FILE_CONTENT_PATTERN;
    }
}

