/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.ConditionalStructure;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH$J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH$J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J \u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/sonarsource/kotlin/checks/AbstractBranchDuplication;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "checkDuplicatedBranches", "", "ctx", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "tree", "Lorg/jetbrains/kotlin/psi/KtElement;", "branches", "", "onAllIdenticalBranches", "visitIfExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "context", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "checkConditionalStructure", "conditional", "Lorg/sonarsource/kotlin/checks/ConditionalStructure;", "sonar-kotlin-checks"})
public abstract class AbstractBranchDuplication
extends AbstractCheck {
    protected abstract void checkDuplicatedBranches(@NotNull KotlinFileContext var1, @NotNull KtElement var2, @NotNull List<? extends KtElement> var3);

    protected abstract void onAllIdenticalBranches(@NotNull KotlinFileContext var1, @NotNull KtElement var2);

    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        PsiElement parent2 = expression2.getParent().getParent();
        if (!(parent2 instanceof KtIfExpression) || Intrinsics.areEqual(expression2, ((KtIfExpression)parent2).getThen())) {
            this.checkConditionalStructure(context, expression2, new ConditionalStructure(expression2));
        }
    }

    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        this.checkConditionalStructure(context, expression2, new ConditionalStructure(expression2));
    }

    private final void checkConditionalStructure(KotlinFileContext ctx, KtElement tree, ConditionalStructure conditional) {
        if (conditional.getAllBranchesArePresent() && conditional.allBranchesAreIdentical()) {
            this.onAllIdenticalBranches(ctx, tree);
        } else {
            this.checkDuplicatedBranches(ctx, tree, conditional.getBranches());
        }
    }
}

