/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.K1only;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.AndroidBroadcastingCheckKt;

@K1only
@Rule(key="S5320")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005H\u0002J\"\u0010\u0018\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005H\u0002J\"\u0010\u0019\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005H\u0002J\"\u0010\u001a\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lorg/sonarsource/kotlin/checks/AndroidBroadcastingCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "isSendOrderedBroadcastAsUser", "", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "name", "", "argumentsByIndex", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "isSendOrderedBroadcast", "isSendBroadcastAsUser", "isSendBroadcast", "sonar-kotlin-checks"})
public final class AndroidBroadcastingCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit = CollectionsKt.listOf(FunMatcherKt.FunMatcher$default(null, null, null, "android.content.Context", false, null, null, null, null, null, AndroidBroadcastingCheck::functionsToVisit$lambda$0, 1015, null));

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        List<ResolvedValueArgument> list = resolvedCall2.getValueArgumentsByIndex();
        if (list == null) {
            return;
        }
        List<ResolvedValueArgument> arguments2 = list;
        String string2 = ((Named)resolvedCall2.getResultingDescriptor()).getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        String name = string2;
        BindingContext $this$visitFunctionCall_u24lambda_u241 = kotlinFileContext.getBindingContext();
        boolean bl = false;
        boolean bl2 = AndroidBroadcastingCheckKt.access$getSTICKY_BROADCAST_NAMES$p().contains(name) || this.isSendBroadcast($this$visitFunctionCall_u24lambda_u241, name, arguments2) || this.isSendBroadcastAsUser($this$visitFunctionCall_u24lambda_u241, name, arguments2) || this.isSendOrderedBroadcast($this$visitFunctionCall_u24lambda_u241, name, arguments2) || this.isSendOrderedBroadcastAsUser($this$visitFunctionCall_u24lambda_u241, name, arguments2);
        if (bl2) {
            AbstractCheck abstractCheck = this;
            KtExpression ktExpression = callExpression.getCalleeExpression();
            Intrinsics.checkNotNull(ktExpression);
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)ktExpression, "Make sure that broadcasting intents is safe here.", null, null, 12, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSendOrderedBroadcastAsUser(BindingContext $this$isSendOrderedBroadcastAsUser, String name, List<? extends ResolvedValueArgument> argumentsByIndex) {
        if (!Intrinsics.areEqual(name, "sendOrderedBroadcastAsUser")) return false;
        ResolvedValueArgument resolvedValueArgument = CollectionsKt.getOrNull(argumentsByIndex, 2);
        if (resolvedValueArgument == null) return false;
        boolean bl = ApiExtensionsKt.isNull(resolvedValueArgument, $this$isSendOrderedBroadcastAsUser);
        if (!bl) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSendOrderedBroadcast(BindingContext $this$isSendOrderedBroadcast, String name, List<? extends ResolvedValueArgument> argumentsByIndex) {
        if (!Intrinsics.areEqual(name, "sendOrderedBroadcast")) return false;
        ResolvedValueArgument resolvedValueArgument = CollectionsKt.getOrNull(argumentsByIndex, 1);
        if (resolvedValueArgument == null) return false;
        boolean bl = ApiExtensionsKt.isNull(resolvedValueArgument, $this$isSendOrderedBroadcast);
        if (!bl) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSendBroadcastAsUser(BindingContext $this$isSendBroadcastAsUser, String name, List<? extends ResolvedValueArgument> argumentsByIndex) {
        if (!Intrinsics.areEqual(name, "sendBroadcast")) return false;
        ResolvedValueArgument resolvedValueArgument = CollectionsKt.getOrNull(argumentsByIndex, 1);
        if (resolvedValueArgument == null) return true;
        boolean bl = ApiExtensionsKt.isNull(resolvedValueArgument, $this$isSendBroadcastAsUser);
        if (!bl) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSendBroadcast(BindingContext $this$isSendBroadcast, String name, List<? extends ResolvedValueArgument> argumentsByIndex) {
        if (!Intrinsics.areEqual(name, "sendBroadcastAsUser")) return false;
        ResolvedValueArgument resolvedValueArgument = CollectionsKt.getOrNull(argumentsByIndex, 2);
        if (resolvedValueArgument == null) return true;
        boolean bl = ApiExtensionsKt.isNull(resolvedValueArgument, $this$isSendBroadcast);
        if (!bl) return false;
        return true;
    }

    private static final Unit functionsToVisit$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"sendBroadcast", "sendBroadcastAsUser", "sendOrderedBroadcast", "sendOrderedBroadcastAsUser", "sendStickyBroadcast", "sendStickyBroadcastAsUser", "sendStickyOrderedBroadcast", "sendStickyOrderedBroadcastAsUser"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }
}

