/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\rJ\u000e\u0010\u000e\u001a\u00020\u000f*\u0004\u0018\u00010\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/sonarsource/kotlin/checks/CognitiveComplexity;", "", "root", "Lorg/jetbrains/kotlin/psi/KtElement;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "getRoot", "()Lorg/jetbrains/kotlin/psi/KtElement;", "increments", "", "Lorg/sonarsource/kotlin/checks/CognitiveComplexity$Increment;", "value", "", "", "isLogicalBinaryExpression", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Increment", "CognitiveComplexityVisitor", "sonar-kotlin-checks"})
public final class CognitiveComplexity {
    @NotNull
    private final KtElement root;
    @NotNull
    private final List<Increment> increments;

    public CognitiveComplexity(@NotNull KtElement root) {
        Intrinsics.checkNotNullParameter(root, "root");
        this.root = root;
        this.increments = new ArrayList();
        CognitiveComplexityVisitor visitor2 = new CognitiveComplexityVisitor();
        this.root.accept(visitor2);
    }

    @NotNull
    public final KtElement getRoot() {
        return this.root;
    }

    public final int value() {
        int total = 0;
        for (Increment increment : this.increments) {
            total += increment.getNestingLevel() + 1;
        }
        return total;
    }

    @NotNull
    public final List<Increment> increments() {
        return this.increments;
    }

    private final boolean isLogicalBinaryExpression(KtExpression $this$isLogicalBinaryExpression) {
        return $this$isLogicalBinaryExpression instanceof KtBinaryExpression && (Intrinsics.areEqual(((KtBinaryExpression)$this$isLogicalBinaryExpression).getOperationToken(), KtTokens.ANDAND) || Intrinsics.areEqual(((KtBinaryExpression)$this$isLogicalBinaryExpression).getOperationToken(), KtTokens.OROR));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u001a\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00162\u0006\u0010 \u001a\u00020\u0017H\u0002J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/sonarsource/kotlin/checks/CognitiveComplexity$CognitiveComplexityVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "<init>", "(Lorg/sonarsource/kotlin/checks/CognitiveComplexity;)V", "alreadyConsideredOperators", "", "Lorg/jetbrains/kotlin/psi/KtOperationReferenceExpression;", "visitExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitCatchSection", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "handleBinaryExpressions", "tree", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "flattenOperators", "operators", "", "incrementWithNesting", "token", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtElement;", "incrementWithoutNesting", "increment", "nestingLevel", "", "ktElement", "isElseIfBranch", "", "parent", "t", "handleIfExpression", "ifExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "sonar-kotlin-checks"})
    @SourceDebugExtension(value={"SMAP\nCognitiveComplexity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CognitiveComplexity.kt\norg/sonarsource/kotlin/checks/CognitiveComplexity$CognitiveComplexityVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1#2:170\n*E\n"})
    private final class CognitiveComplexityVisitor
    extends KtTreeVisitorVoid {
        @NotNull
        private final Set<KtOperationReferenceExpression> alreadyConsideredOperators = new HashSet();

        @Override
        public void visitExpression(@NotNull KtExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            KtExpression ktExpression = expression2;
            if (ktExpression instanceof KtForExpression) {
                PsiElement psiElement = ((KtForExpression)expression2).getForKeyword();
                Intrinsics.checkNotNullExpressionValue(psiElement, "getForKeyword(...)");
                this.incrementWithNesting(psiElement, expression2);
            } else if (ktExpression instanceof KtWhileExpression) {
                PsiElement psiElement = ((KtWhileExpression)expression2).getFirstChild();
                Intrinsics.checkNotNullExpressionValue(psiElement, "getFirstChild(...)");
                this.incrementWithNesting(psiElement, expression2);
            } else if (ktExpression instanceof KtWhenExpression) {
                PsiElement psiElement = ((KtWhenExpression)expression2).getWhenKeyword();
                Intrinsics.checkNotNullExpressionValue(psiElement, "getWhenKeyword(...)");
                this.incrementWithNesting(psiElement, expression2);
            } else if (ktExpression instanceof KtBreakExpression) {
                KtContainerNode ktContainerNode = ((KtBreakExpression)expression2).getLabelQualifier();
                if (ktContainerNode != null) {
                    KtContainerNode it = ktContainerNode;
                    boolean bl = false;
                    PsiElement psiElement = ((KtBreakExpression)expression2).getFirstChild();
                    Intrinsics.checkNotNullExpressionValue(psiElement, "getFirstChild(...)");
                    this.incrementWithoutNesting(psiElement);
                }
            } else if (ktExpression instanceof KtContinueExpression) {
                KtContainerNode ktContainerNode = ((KtContinueExpression)expression2).getLabelQualifier();
                if (ktContainerNode != null) {
                    KtContainerNode it = ktContainerNode;
                    boolean bl = false;
                    PsiElement psiElement = ((KtContinueExpression)expression2).getFirstChild();
                    Intrinsics.checkNotNullExpressionValue(psiElement, "getFirstChild(...)");
                    this.incrementWithoutNesting(psiElement);
                }
            } else if (ktExpression instanceof KtIfExpression) {
                this.handleIfExpression((KtIfExpression)expression2);
            } else if (ktExpression instanceof KtBinaryExpression) {
                this.handleBinaryExpressions((KtBinaryExpression)expression2);
            }
            super.visitExpression(expression2);
        }

        @Override
        public void visitCatchSection(@NotNull KtCatchClause catchClause) {
            Intrinsics.checkNotNullParameter(catchClause, "catchClause");
            PsiElement psiElement = catchClause.getFirstChild();
            Intrinsics.checkNotNullExpressionValue(psiElement, "getFirstChild(...)");
            this.incrementWithNesting(psiElement, catchClause);
            super.visitCatchSection(catchClause);
        }

        private final void handleBinaryExpressions(KtBinaryExpression tree) {
            if (!CognitiveComplexity.this.isLogicalBinaryExpression(tree) || this.alreadyConsideredOperators.contains(tree.getOperationReference())) {
                return;
            }
            List operators = new ArrayList();
            this.flattenOperators(tree, operators);
            KtOperationReferenceExpression previous = null;
            for (KtOperationReferenceExpression operator : operators) {
                block6: {
                    block5: {
                        if (previous == null) break block5;
                        KtSingleValueToken ktSingleValueToken = previous.getOperationSignTokenType();
                        KtSingleValueToken ktSingleValueToken2 = operator.getOperationSignTokenType();
                        if (Intrinsics.areEqual(ktSingleValueToken != null ? ktSingleValueToken.getValue() : null, ktSingleValueToken2 != null ? ktSingleValueToken2.getValue() : null)) break block6;
                    }
                    this.incrementWithoutNesting(operator);
                }
                previous = operator;
                this.alreadyConsideredOperators.add(operator);
            }
        }

        private final void flattenOperators(KtBinaryExpression tree, List<KtOperationReferenceExpression> operators) {
            if (CognitiveComplexity.this.isLogicalBinaryExpression(tree.getLeft())) {
                KtExpression ktExpression = tree.getLeft();
                Intrinsics.checkNotNull(ktExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                this.flattenOperators((KtBinaryExpression)ktExpression, operators);
            }
            KtOperationReferenceExpression ktOperationReferenceExpression = tree.getOperationReference();
            Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "getOperationReference(...)");
            operators.add(ktOperationReferenceExpression);
            if (CognitiveComplexity.this.isLogicalBinaryExpression(tree.getRight())) {
                KtExpression ktExpression = tree.getRight();
                Intrinsics.checkNotNull(ktExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                this.flattenOperators((KtBinaryExpression)ktExpression, operators);
            }
        }

        private final void incrementWithNesting(PsiElement token, KtElement tree) {
            this.increment(token, this.nestingLevel(tree));
        }

        private final void incrementWithoutNesting(PsiElement token) {
            this.increment(token, 0);
        }

        private final void increment(PsiElement token, int nestingLevel) {
            CognitiveComplexity.this.increments.add(new Increment(token, nestingLevel));
        }

        private final int nestingLevel(KtElement ktElement) {
            int nestingLevel = 0;
            boolean isInsideFunction = CognitiveComplexity.this.getRoot() instanceof KtFunction;
            ArrayDeque<PsiElement> ancestors = new ArrayDeque<PsiElement>();
            for (PsiElement parent2 = ktElement.getParent(); parent2 != null && !Intrinsics.areEqual(parent2, CognitiveComplexity.this.getRoot()); parent2 = parent2.getParent()) {
                ancestors.addFirst(parent2);
            }
            for (PsiElement element : ancestors) {
                block9: {
                    block8: {
                        block7: {
                            if (element instanceof KtFunction) {
                                if (isInsideFunction) {
                                    ++nestingLevel;
                                }
                                isInsideFunction = true;
                                continue;
                            }
                            if (!(element instanceof KtIfExpression)) break block7;
                            PsiElement psiElement = ((KtIfExpression)element).getParent();
                            if (!this.isElseIfBranch(psiElement != null ? psiElement.getParent() : null, (KtElement)element)) break block8;
                        }
                        if (!(element instanceof KtWhenExpression) && !(element instanceof KtLoopExpression) && !(element instanceof KtCatchClause)) break block9;
                    }
                    ++nestingLevel;
                    continue;
                }
                if (!(element instanceof KtClass)) continue;
                nestingLevel = 0;
                isInsideFunction = false;
            }
            return nestingLevel;
        }

        private final boolean isElseIfBranch(PsiElement parent2, KtElement t) {
            return parent2 instanceof KtIfExpression && ((KtIfExpression)parent2).getElse() == t;
        }

        private final void handleIfExpression(KtIfExpression ifExpression) {
            block2: {
                boolean isElseIf;
                PsiElement parent2;
                PsiElement psiElement = parent2 = ifExpression.getParent();
                PsiElement preParent = psiElement != null ? psiElement.getParent() : null;
                boolean bl = isElseIf = preParent instanceof KtIfExpression && ifExpression == ((KtIfExpression)preParent).getElse();
                if (!isElseIf) {
                    PsiElement psiElement2 = ifExpression.getIfKeyword();
                    Intrinsics.checkNotNullExpressionValue(psiElement2, "getIfKeyword(...)");
                    this.incrementWithNesting(psiElement2, ifExpression);
                }
                KtExpression ktExpression = ifExpression.getElse();
                if (ktExpression == null) break block2;
                KtExpression it = ktExpression;
                boolean bl2 = false;
                if (it instanceof KtBlockExpression || it instanceof KtIfExpression) {
                    PsiElement psiElement3 = ifExpression.getElseKeyword();
                    Intrinsics.checkNotNull(psiElement3);
                    this.incrementWithoutNesting(psiElement3);
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/sonarsource/kotlin/checks/CognitiveComplexity$Increment;", "", "token", "Lcom/intellij/psi/PsiElement;", "nestingLevel", "", "<init>", "(Lcom/intellij/psi/PsiElement;I)V", "getToken", "()Lcom/intellij/psi/PsiElement;", "getNestingLevel", "()I", "sonar-kotlin-checks"})
    public static final class Increment {
        @NotNull
        private final PsiElement token;
        private final int nestingLevel;

        public Increment(@NotNull PsiElement token, int nestingLevel) {
            Intrinsics.checkNotNullParameter(token, "token");
            this.token = token;
            this.nestingLevel = nestingLevel;
        }

        @NotNull
        public final PsiElement getToken() {
            return this.token;
        }

        public final int getNestingLevel() {
            return this.nestingLevel;
        }
    }
}

