/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.frontend.K1only;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.CollectionInappropriateCallsCheckKt;

@K1only
@Rule(key="S2175")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/sonarsource/kotlin/checks/CollectionInappropriateCallsCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "matchedFun", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
public final class CollectionInappropriateCallsCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit;

    public CollectionInappropriateCallsCheck() {
        FunMatcherImpl[] funMatcherImplArray = new FunMatcherImpl[]{CollectionInappropriateCallsCheckKt.getCOLLECTION_EXTENSIONS_MATCHER(), CollectionInappropriateCallsCheckKt.getCOLLECTION_ARGUMENT_EXTENSIONS_MATCHER(), CollectionInappropriateCallsCheckKt.getCONTAINS_VALUE_MATCHER()};
        this.functionsToVisit = CollectionsKt.listOf(funMatcherImplArray);
    }

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull FunMatcherImpl matchedFun, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(matchedFun, "matchedFun");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        BindingContext ctx = kotlinFileContext.getBindingContext();
        List<KtValueArgument> list = callExpression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
        KtValueArgument arg = CollectionsKt.first(list);
        KotlinType kotlinType = ApiExtensionsKt.determineType(arg, ctx);
        if (kotlinType == null) {
            return;
        }
        KotlinType argType = kotlinType;
        KotlinType kotlinType2 = ApiExtensionsKt.determineType(ApiExtensionsKt.predictReceiverExpression$default(callExpression, ctx, null, 2, null), ctx);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType collectionType = kotlinType2;
        if (collectionType.getArguments().isEmpty()) {
            return;
        }
        Integer n = CollectionInappropriateCallsCheckKt.getFunMatcherToArgumentIndexMap().get(matchedFun);
        Intrinsics.checkNotNull(n);
        int collectionArgumentIndex = ((Number)n).intValue();
        KotlinType kotlinType3 = collectionType.getArguments().get(collectionArgumentIndex).getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType3, "getType(...)");
        KotlinType collectionArgumentType = TypeUtilsKt.makeNotNullable(kotlinType3);
        if (Intrinsics.areEqual(matchedFun, CollectionInappropriateCallsCheckKt.getCOLLECTION_ARGUMENT_EXTENSIONS_MATCHER())) {
            argType = CollectionsKt.first(argType.getArguments()).getType();
        }
        if (TypeUtilsKt.isTypeParameter(argType = TypeUtilsKt.makeNotNullable(argType)) || TypeUtilsKt.isTypeParameter(collectionArgumentType)) {
            return;
        }
        if (!(Intrinsics.areEqual(argType, collectionArgumentType) || ApiExtensionsKt.isSupertypeOf(collectionArgumentType, argType) || ApiExtensionsKt.isSupertypeOf(argType, collectionArgumentType))) {
            AbstractCheck abstractCheck = this;
            Intrinsics.checkNotNull(arg);
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)arg, "This key/object cannot ever be present in the collection", null, null, 12, null);
        }
    }
}

