/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.K1only;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.CoroutinesTimeoutApiUnusedCheckKt;

@K1only
@Rule(key="S6316")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/sonarsource/kotlin/checks/CoroutinesTimeoutApiUnusedCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "asDelayCallIfMatching", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "Lcom/intellij/psi/PsiElement;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "asInitializerCallIfMatching", "targetInitializer", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "sonar-kotlin-checks"})
public final class CoroutinesTimeoutApiUnusedCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit = CollectionsKt.listOf(FunMatcherKt.FunMatcher$default(null, "cancel", null, "kotlinx.coroutines.Job", false, null, null, null, null, null, null, 2037, null));

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        DeclarationDescriptor declarationDescriptor;
        SecondaryLocation[] secondaryLocationArray;
        Collection<DeclarationDescriptor> collection;
        KtDotQualifiedExpression ktDotQualifiedExpression;
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        BindingContext bindingContext = kotlinFileContext.getBindingContext();
        KtExpression ktExpression = callExpression.getCalleeExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression cancelCallCalleeExpression = ktExpression;
        PsiElement psiElement = callExpression.getContext();
        KtDotQualifiedExpression ktDotQualifiedExpression2 = ktDotQualifiedExpression = psiElement instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement : null;
        if (ktDotQualifiedExpression == null || (psiElement = ktDotQualifiedExpression.getReceiverExpression()) == null || (collection = BindingContextUtilsKt.getReferenceTargets((KtExpression)psiElement, bindingContext)) == null || (secondaryLocationArray = CollectionsKt.toList((Iterable)collection)) == null || (declarationDescriptor = (DeclarationDescriptor)CollectionsKt.getOrNull(secondaryLocationArray, 0)) == null) {
            return;
        }
        DeclarationDescriptor jobDeclaration = declarationDescriptor;
        PsiElement psiElement2 = callExpression.getParent();
        Intrinsics.checkNotNullExpressionValue(psiElement2, "getParent(...)");
        Iterator<PsiElement> siblingIter = SequencesKt.filter(PsiUtilsKt.siblings(psiElement2, false, false), CoroutinesTimeoutApiUnusedCheck::visitFunctionCall$lambda$0).iterator();
        if (!siblingIter.hasNext()) {
            return;
        }
        PsiElement psiElement3 = siblingIter.next();
        Intrinsics.checkNotNullExpressionValue(psiElement3, "next(...)");
        KtExpression ktExpression2 = this.asDelayCallIfMatching(psiElement3, bindingContext);
        if (ktExpression2 == null) {
            return;
        }
        KtExpression delayCall = ktExpression2;
        PsiElement psiElement4 = siblingIter.next();
        Intrinsics.checkNotNullExpressionValue(psiElement4, "next(...)");
        KtExpression ktExpression3 = this.asInitializerCallIfMatching(psiElement4, jobDeclaration, bindingContext);
        if (ktExpression3 == null) {
            return;
        }
        KtExpression initializerCall = ktExpression3;
        secondaryLocationArray = new SecondaryLocation[]{new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, delayCall), null, 2, null), new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, initializerCall), null, 2, null)};
        AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)cancelCallCalleeExpression, "Use \"withTimeoutOrNull { }\" instead of manual delayed cancellation.", CollectionsKt.listOf(secondaryLocationArray), null, 8, null);
    }

    private final KtExpression asDelayCallIfMatching(PsiElement element, BindingContext bindingContext) {
        return element instanceof KtCallExpression && FunMatcherKt.matches(CallUtilKt.getResolvedCall((KtElement)element, bindingContext), CoroutinesTimeoutApiUnusedCheckKt.access$getDELAY_MATCHER$p()) ? ((KtCallExpression)element).getCalleeExpression() : null;
    }

    private final KtExpression asInitializerCallIfMatching(PsiElement element, DeclarationDescriptor targetInitializer, BindingContext bindingContext) {
        if (element instanceof KtProperty && bindingContext.get(BindingContext.VARIABLE, element) == targetInitializer) {
            KtExpression ktExpression = ((KtProperty)element).getInitializer();
            KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression initializer = ktCallExpression;
            if (FunMatcherKt.matches(CallUtilKt.getResolvedCall(initializer, bindingContext), CoroutinesTimeoutApiUnusedCheckKt.access$getLAUNCH_ASYNC_MATCHER$p())) {
                return initializer.getCalleeExpression();
            }
        }
        return null;
    }

    private static final boolean visitFunctionCall$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof KtElement;
    }
}

