/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.K1only;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.DelegationPatternCheckKt;

@K1only
@Rule(key="S6514")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/sonarsource/kotlin/checks/DelegationPatternCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitClassOrObject", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "checkNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "superInterfaces", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nDelegationPatternCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DelegationPatternCheck.kt\norg/sonarsource/kotlin/checks/DelegationPatternCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1863#2,2:136\n1755#2,3:138\n*S KotlinDebug\n*F\n+ 1 DelegationPatternCheck.kt\norg/sonarsource/kotlin/checks/DelegationPatternCheck\n*L\n59#1:136,2\n71#1:138,3\n*E\n"})
public final class DelegationPatternCheck
extends AbstractCheck {
    @Override
    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
        Intrinsics.checkNotNullParameter(context, "context");
        KotlinType kotlinType = ApiExtensionsKt.determineType(classOrObject, context.getBindingContext());
        if (kotlinType == null) {
            return;
        }
        KotlinType classType = kotlinType;
        if (TypeUtilsKt.isInterface(classType)) {
            return;
        }
        Set superInterfaces = CollectionsKt.toSet(DelegationPatternCheckKt.access$getSuperInterfaces(classType));
        if (superInterfaces.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = classOrObject.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtDeclaration it = (KtDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof KtNamedFunction)) continue;
            this.checkNamedFunction((KtNamedFunction)it, superInterfaces, context);
        }
    }

    private final void checkNamedFunction(KtNamedFunction function2, Set<? extends KotlinType> superInterfaces, KotlinFileContext context) {
        boolean bl;
        block6: {
            if (!KtPsiUtilKt.isPublic(function2) || !ApiExtensionsKt.overrides(function2)) {
                return;
            }
            BindingContext bindingContext = context.getBindingContext();
            Object object = DelegationPatternCheckKt.access$getDelegeeOrNull(function2, bindingContext);
            if (object == null || (object = ApiExtensionsKt.determineType((PsiElement)object, bindingContext)) == null) {
                return;
            }
            Object delegeeType = object;
            Iterable $this$any$iv = DelegationPatternCheckKt.getCommonSuperInterfaces(superInterfaces, (KotlinType)delegeeType);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!DelegationPatternCheckKt.access$isFunctionInInterface(function2, it, bindingContext)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = function2.getNameIdentifier();
            Intrinsics.checkNotNull(psiElement);
            AbstractCheck.reportIssue$default(abstractCheck, context, psiElement, "Replace with interface delegation using \"by\" in the class header.", null, null, 12, null);
        }
    }
}

