/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\b"}, d2={"ALGORITHM_PATTERN", "Lkotlin/text/Regex;", "CIPHER_GET_INSTANCE_MATCHER", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getCIPHER_GET_INSTANCE_MATCHER", "()Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getInsecureAlgorithmMessage", "", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nEncryptionAlgorithmCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptionAlgorithmCheck.kt\norg/sonarsource/kotlin/checks/EncryptionAlgorithmCheckKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class EncryptionAlgorithmCheckKt {
    @NotNull
    private static final Regex ALGORITHM_PATTERN = new Regex("([^/]+)/([^/]+)/([^/]+)");
    @NotNull
    private static final FunMatcherImpl CIPHER_GET_INSTANCE_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, EncryptionAlgorithmCheckKt::CIPHER_GET_INSTANCE_MATCHER$lambda$0, 1023, null);

    @NotNull
    public static final FunMatcherImpl getCIPHER_GET_INSTANCE_MATCHER() {
        return CIPHER_GET_INSTANCE_MATCHER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getInsecureAlgorithmMessage(String $this$getInsecureAlgorithmMessage) {
        MatchResult matcher = ALGORITHM_PATTERN.matchEntire($this$getInsecureAlgorithmMessage);
        if (matcher == null) return "Use secure mode and padding scheme.";
        List<String> list = matcher.getGroupValues();
        if (list == null) return "Use secure mode and padding scheme.";
        List<String> list2 = list;
        boolean bl = false;
        String algorithm = list2.get(1);
        String mode = list2.get(2);
        String padding = list2.get(3);
        boolean isRSA = StringsKt.equals("RSA", algorithm, true);
        if (StringsKt.equals("ECB", mode, true) && !isRSA) {
            return "Use a secure cipher mode.";
        }
        if (StringsKt.equals("CBC", mode, true) && !StringsKt.equals("NoPadding", padding, true)) {
            return "Use another cipher mode or disable padding.";
        }
        if (!isRSA) return null;
        String string2 = padding.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        if (StringsKt.startsWith$default(string2, "OAEP", false, 2, null)) return null;
        return "Use a secure padding scheme.";
    }

    private static final Unit CIPHER_GET_INSTANCE_MATCHER$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.setQualifier("javax.crypto.Cipher");
        $this$FunMatcher.setName("getInstance");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$getInsecureAlgorithmMessage(String $receiver) {
        return EncryptionAlgorithmCheckKt.getInsecureAlgorithmMessage($receiver);
    }
}

