/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.EqualsMethodUsageCheckKt;

@Rule(key="S6519")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/sonarsource/kotlin/checks/EqualsMethodUsageCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/Set;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
public final class EqualsMethodUsageCheck
extends CallAbstractCheck {
    @NotNull
    private final Set<FunMatcherImpl> functionsToVisit = SetsKt.setOf(FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, EqualsMethodUsageCheck::functionsToVisit$lambda$0, 1023, null));

    @NotNull
    public Set<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        PsiElement parent2 = callExpression.getParent();
        if (parent2 instanceof KtDotQualifiedExpression && Intrinsics.areEqual(((KtDotQualifiedExpression)parent2).getSelectorExpression(), callExpression) && !EqualsMethodUsageCheckKt.access$isSuperOrOuterClass(((KtDotQualifiedExpression)parent2).getReceiverExpression())) {
            PsiElement grandParent = this.skipParentParentheses(((KtDotQualifiedExpression)parent2).getParent());
            KtExpression ktExpression = callExpression.getCalleeExpression();
            Intrinsics.checkNotNull(ktExpression);
            KtExpression callee = ktExpression;
            if (grandParent instanceof KtPrefixExpression && Intrinsics.areEqual(((KtPrefixExpression)grandParent).getOperationToken(), KtTokens.EXCL)) {
                KtSimpleNameExpression ktSimpleNameExpression = ((KtPrefixExpression)grandParent).getOperationReference();
                Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "getOperationReference(...)");
                List<SecondaryLocation> secondaryLocations = CollectionsKt.listOf(new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, ktSimpleNameExpression), "Negation"));
                AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)callee, "Replace \"!\" and \"equals\" with binary operator \"!=\".", secondaryLocations, null, 8, null);
            } else {
                AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)callee, "Replace \"equals\" with binary operator \"==\".", null, null, 12, null);
            }
        }
    }

    private static final Unit functionsToVisit$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.setName("equals");
        String[] stringArray = new String[]{"kotlin.Any"};
        $this$FunMatcher.withArguments(stringArray);
        return Unit.INSTANCE;
    }
}

