/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.EqualsOverridenWithHashCodeCheckKt;

@Rule(key="S1206")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/sonarsource/kotlin/checks/EqualsOverridenWithHashCodeCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitClassBody", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "ctx", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nEqualsOverridenWithHashCodeCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EqualsOverridenWithHashCodeCheck.kt\norg/sonarsource/kotlin/checks/EqualsOverridenWithHashCodeCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1863#2,2:67\n*S KotlinDebug\n*F\n+ 1 EqualsOverridenWithHashCodeCheck.kt\norg/sonarsource/kotlin/checks/EqualsOverridenWithHashCodeCheck\n*L\n49#1:67,2\n*E\n"})
public final class EqualsOverridenWithHashCodeCheck
extends AbstractCheck {
    @Override
    public void visitClassBody(@NotNull KtClassBody klass, @NotNull KotlinFileContext ctx) {
        block7: {
            KtNamedFunction it;
            Intrinsics.checkNotNullParameter(klass, "klass");
            Intrinsics.checkNotNullParameter(ctx, "ctx");
            KtNamedFunction equalsMethod = null;
            KtNamedFunction hashCodeMethod = null;
            Iterable $this$forEach$iv = klass.getFunctions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtNamedFunction it2 = (KtNamedFunction)element$iv;
                boolean bl = false;
                if (hashCodeMethod == null && EqualsOverridenWithHashCodeCheckKt.access$getHashCodeMatcher$p().matches(it2)) {
                    hashCodeMethod = it2;
                } else if (equalsMethod == null && EqualsOverridenWithHashCodeCheckKt.access$getEqualsMatcher$p().matches(it2)) {
                    equalsMethod = it2;
                }
                if (hashCodeMethod == null || equalsMethod == null) continue;
                return;
            }
            KtNamedFunction ktNamedFunction = equalsMethod;
            if (ktNamedFunction != null) {
                it = ktNamedFunction;
                boolean bl = false;
                if (!ApiExtensionsKt.isAbstract(it)) {
                    AbstractCheck.reportIssue$default((AbstractCheck)this, ctx, (PsiElement)it, "This class overrides \"equals()\" and should therefore also override \"hashCode()\".", null, null, 12, null);
                }
            }
            KtNamedFunction ktNamedFunction2 = hashCodeMethod;
            if (ktNamedFunction2 == null) break block7;
            it = ktNamedFunction2;
            boolean bl = false;
            if (!ApiExtensionsKt.isAbstract(it)) {
                AbstractCheck.reportIssue$default((AbstractCheck)this, ctx, (PsiElement)it, "This class overrides \"hashCode()\" and should therefore also override \"equals()\".", null, null, 12, null);
            }
        }
    }
}

