/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Rule(key="S1451")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/sonarsource/kotlin/checks/FileHeaderCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "headerFormat", "", "getHeaderFormat", "()Ljava/lang/String;", "setHeaderFormat", "(Ljava/lang/String;)V", "isRegularExpression", "", "()Z", "setRegularExpression", "(Z)V", "searchPattern", "Lkotlin/text/Regex;", "expectedLines", "", "initialize", "", "ruleKey", "Lorg/sonar/api/rule/RuleKey;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "hasExpectedHeader", "sonar-kotlin-checks"})
public final class FileHeaderCheck
extends AbstractCheck {
    @RuleProperty(key="headerFormat", description="Expected copyright and license header", defaultValue="", type="TEXT")
    @NotNull
    private String headerFormat = "";
    @RuleProperty(key="isRegularExpression", description="Whether the headerFormat is a regular expression", defaultValue="false")
    private boolean isRegularExpression;
    private Regex searchPattern;
    private List<String> expectedLines;

    @NotNull
    public final String getHeaderFormat() {
        return this.headerFormat;
    }

    public final void setHeaderFormat(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.headerFormat = string2;
    }

    public final boolean isRegularExpression() {
        return this.isRegularExpression;
    }

    public final void setRegularExpression(boolean bl) {
        this.isRegularExpression = bl;
    }

    @Override
    public void initialize(@NotNull RuleKey ruleKey) {
        Intrinsics.checkNotNullParameter(ruleKey, "ruleKey");
        super.initialize(ruleKey);
        if (this.isRegularExpression) {
            try {
                this.searchPattern = new Regex("^" + this.headerFormat);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("[" + this.getClass().getSimpleName() + "] Unable to compile the regular expression: " + this.headerFormat, e);
            }
        } else {
            this.expectedLines = StringsKt.lines(this.headerFormat);
        }
    }

    @Override
    public void visitKtFile(@NotNull KtFile file2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (!this.hasExpectedHeader(file2)) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, null, "Add or update the header of this file.", null, null, 12, null);
        }
    }

    private final boolean hasExpectedHeader(KtFile file2) {
        boolean bl;
        if (this.isRegularExpression) {
            Regex regex = this.searchPattern;
            if (regex == null) {
                Intrinsics.throwUninitializedPropertyAccessException("searchPattern");
                regex = null;
            }
            String string2 = file2.getText();
            Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
            bl = Regex.find$default(regex, string2, 0, 2, null) != null;
        } else {
            List<String> list = this.expectedLines;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException("expectedLines");
                list = null;
            }
            String string3 = file2.getText();
            Intrinsics.checkNotNullExpressionValue(string3, "getText(...)");
            Sequence<String> sequence2 = StringsKt.lineSequence(string3);
            List<String> list2 = this.expectedLines;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("expectedLines");
                list2 = null;
            }
            bl = Intrinsics.areEqual(list, SequencesKt.toList(SequencesKt.take(sequence2, list2.size())));
        }
        return bl;
    }
}

