/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Rule(key="S2068")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0002J\u001c\u0010\u001c\u001a\u00020\u000f*\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J,\u0010 \u001a\u00020\u000f*\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u0005H\u0002J\u000e\u0010&\u001a\u0004\u0018\u00010\u0005*\u00020'H\u0002J(\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u001bH\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010-\u001a\u00020\u0005H\u0002R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/sonarsource/kotlin/checks/HardcodedCredentialsCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "credentialWords", "", "getCredentialWords", "()Ljava/lang/String;", "setCredentialWords", "(Ljava/lang/String;)V", "variablePatterns", "Lkotlin/sequences/Sequence;", "Lkotlin/text/Regex;", "literalPatterns", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "isNotEmptyString", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "report", "tree", "Lcom/intellij/psi/PsiElement;", "matchName", "checkAssignedValue", "matchResult", "Lkotlin/text/MatchResult;", "regex", "leftHand", "value", "identifier", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkVariable", "ctx", "variable", "variableName", "toPatterns", "suffix", "Companion", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nHardcodedCredentialsCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HardcodedCredentialsCheck.kt\norg/sonarsource/kotlin/checks/HardcodedCredentialsCheck\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,144:1\n1#2:145\n1317#3,2:146\n1317#3,2:148\n37#4,2:150\n108#5:152\n80#5,22:153\n*S KotlinDebug\n*F\n+ 1 HardcodedCredentialsCheck.kt\norg/sonarsource/kotlin/checks/HardcodedCredentialsCheck\n*L\n95#1:146,2\n123#1:148,2\n138#1:150,2\n140#1:152\n140#1:153,22\n*E\n"})
public final class HardcodedCredentialsCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="credentialWords", description="Comma separated list of words identifying potential credentials", defaultValue="password,passwd,pwd,passphrase")
    @NotNull
    private String credentialWords = "password,passwd,pwd,passphrase";
    @Nullable
    private Sequence<Regex> variablePatterns;
    @Nullable
    private Sequence<Regex> literalPatterns;
    @NotNull
    private static final String DEFAULT_VALUE = "password,passwd,pwd,passphrase";
    @NotNull
    private static final Regex URI_PREFIX = new Regex("^\\w{1,8}://");

    @NotNull
    public final String getCredentialWords() {
        return this.credentialWords;
    }

    public final void setCredentialWords(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.credentialWords = string2;
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2, @NotNull KotlinFileContext context) {
        block1: {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context, "context");
            if (!Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.EQ) && !Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.PLUSEQ)) break block1;
            KtExpression left = expression2.getLeft();
            Object object = left;
            if (object != null && (object = this.identifier((KtExpression)object)) != null) {
                Object it = object;
                boolean bl = false;
                PsiElement psiElement = left;
                KtExpression ktExpression = expression2.getRight();
                Intrinsics.checkNotNull(ktExpression);
                this.checkVariable(context, psiElement, (String)it, ktExpression);
            }
        }
    }

    @Override
    public void visitProperty(@NotNull KtProperty property, @NotNull KotlinFileContext context) {
        block0: {
            Intrinsics.checkNotNullParameter(property, "property");
            Intrinsics.checkNotNullParameter(context, "context");
            KtExpression ktExpression = property.getInitializer();
            if (ktExpression == null) break block0;
            KtExpression it = ktExpression;
            boolean bl = false;
            PsiElement psiElement = property.getNameIdentifier();
            Intrinsics.checkNotNull(psiElement);
            String string2 = property.getName();
            Intrinsics.checkNotNull(string2);
            this.checkVariable(context, psiElement, string2, it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, @NotNull KotlinFileContext context) {
        String content;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        String string2 = content = !expression2.hasInterpolation() ? this.asConstant(expression2) : "";
        if (HardcodedCredentialsCheck.Companion.isURIWithCredentials(content)) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)expression2, "Review this hard-coded URL, which may contain a credential.", null, null, 12, null);
        } else {
            void $this$forEach$iv;
            Sequence<String> sequence2 = SequencesKt.filter(SequencesKt.map(SequencesKt.mapNotNull(this.literalPatterns(), arg_0 -> HardcodedCredentialsCheck.visitStringTemplateExpression$lambda$2(content, arg_0)), HardcodedCredentialsCheck::visitStringTemplateExpression$lambda$3), arg_0 -> HardcodedCredentialsCheck.visitStringTemplateExpression$lambda$4(content, arg_0));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String credential = (String)element$iv;
                boolean bl = false;
                this.report(context, expression2, credential);
            }
        }
    }

    private final boolean isNotEmptyString(KtElement $this$isNotEmptyString) {
        return $this$isNotEmptyString instanceof KtStringTemplateExpression && !((KtStringTemplateExpression)$this$isNotEmptyString).hasInterpolation() && ((CharSequence)this.asConstant((KtStringTemplateExpression)$this$isNotEmptyString)).length() > 0;
    }

    private final void report(KotlinFileContext $this$report, PsiElement tree, String matchName) {
        AbstractCheck.reportIssue$default((AbstractCheck)this, $this$report, tree, "\"" + matchName + "\" detected here, make sure this is not a hard-coded credential.", null, null, 12, null);
    }

    private final void checkAssignedValue(KotlinFileContext $this$checkAssignedValue, MatchResult matchResult, Regex regex, PsiElement leftHand, String value2) {
        if (!regex.containsMatchIn(value2)) {
            MatchGroup matchGroup = matchResult.getGroups().get(1);
            Intrinsics.checkNotNull(matchGroup);
            this.report($this$checkAssignedValue, leftHand, matchGroup.getValue());
        }
    }

    private final String identifier(KtExpression $this$identifier) {
        String string2;
        KtExpression ktExpression = $this$identifier;
        if (ktExpression instanceof KtNameReferenceExpression) {
            string2 = ((KtNameReferenceExpression)$this$identifier).getReferencedName();
        } else if (ktExpression instanceof KtDotQualifiedExpression) {
            KtExpression ktExpression2 = ((KtDotQualifiedExpression)$this$identifier).getSelectorExpression();
            string2 = ktExpression2 != null ? this.identifier(ktExpression2) : null;
        } else {
            string2 = null;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVariable(KotlinFileContext ctx, PsiElement variable, String variableName, KtElement value2) {
        if (this.isNotEmptyString(value2)) {
            void $this$forEach$iv;
            Sequence<Pair> sequence2 = SequencesKt.mapNotNull(this.variablePatterns(), arg_0 -> HardcodedCredentialsCheck.checkVariable$lambda$7(variableName, arg_0));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                MatchResult matcher = (MatchResult)pair.component1();
                Regex regex = (Regex)pair.component2();
                Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
                this.checkAssignedValue(ctx, matcher, regex, variable, this.asConstant((KtStringTemplateExpression)value2));
            }
        }
    }

    private final Sequence<Regex> variablePatterns() {
        Sequence<Regex> sequence2 = this.variablePatterns;
        if (sequence2 == null) {
            sequence2 = this.toPatterns("");
        }
        return sequence2;
    }

    private final Sequence<Regex> literalPatterns() {
        Sequence<Regex> sequence2 = this.literalPatterns;
        if (sequence2 == null) {
            sequence2 = this.toPatterns("=\\S");
        }
        return sequence2;
    }

    private final Sequence<Regex> toPatterns(String suffix) {
        String[] stringArray = new String[]{","};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)this.credentialWords, stringArray, false, 0, 6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return SequencesKt.map(SequencesKt.map(ArraysKt.asSequence(thisCollection$iv.toArray(new String[0])), HardcodedCredentialsCheck::toPatterns$lambda$10), arg_0 -> HardcodedCredentialsCheck.toPatterns$lambda$11(suffix, arg_0));
    }

    private static final MatchResult visitStringTemplateExpression$lambda$2(String $content, Regex regex) {
        Intrinsics.checkNotNullParameter(regex, "regex");
        return Regex.find$default(regex, $content, 0, 2, null);
    }

    private static final String visitStringTemplateExpression$lambda$3(MatchResult matchResult) {
        Intrinsics.checkNotNullParameter(matchResult, "matchResult");
        MatchGroup matchGroup = matchResult.getGroups().get(1);
        Intrinsics.checkNotNull(matchGroup);
        return matchGroup.getValue();
    }

    private static final boolean visitStringTemplateExpression$lambda$4(String $content, String match) {
        Intrinsics.checkNotNullParameter(match, "match");
        return !HardcodedCredentialsCheck.Companion.isQuery($content, match);
    }

    private static final Pair checkVariable$lambda$7(String $variableName, Regex regex) {
        Pair<MatchResult, Regex> pair;
        Intrinsics.checkNotNullParameter(regex, "regex");
        MatchResult matchResult = Regex.find$default(regex, $variableName, 0, 2, null);
        if (matchResult != null) {
            MatchResult it = matchResult;
            boolean bl = false;
            pair = TuplesKt.to(it, regex);
        } else {
            pair = null;
        }
        return pair;
    }

    private static final String toPatterns$lambda$10(String obj) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        String $this$trim$iv = obj;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    private static final Regex toPatterns$lambda$11(String $suffix, String word) {
        Intrinsics.checkNotNullParameter(word, "word");
        return new Regex("(" + word + ")" + $suffix, RegexOption.IGNORE_CASE);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/sonarsource/kotlin/checks/HardcodedCredentialsCheck$Companion;", "", "<init>", "()V", "DEFAULT_VALUE", "", "URI_PREFIX", "Lkotlin/text/Regex;", "isURIWithCredentials", "", "stringLiteral", "isQuery", "value", "match", "sonar-kotlin-checks"})
    @SourceDebugExtension(value={"SMAP\nHardcodedCredentialsCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HardcodedCredentialsCheck.kt\norg/sonarsource/kotlin/checks/HardcodedCredentialsCheck$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,144:1\n37#2,2:145\n*S KotlinDebug\n*F\n+ 1 HardcodedCredentialsCheck.kt\norg/sonarsource/kotlin/checks/HardcodedCredentialsCheck$Companion\n*L\n53#1:145,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isURIWithCredentials(String stringLiteral) {
            if (URI_PREFIX.containsMatchIn(stringLiteral)) {
                try {
                    String userInfo = new URI(stringLiteral).getUserInfo();
                    if (userInfo != null) {
                        String[] stringArray = new String[]{":"};
                        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)userInfo, stringArray, false, 0, 6, null);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        String[] parts = thisCollection$iv.toArray(new String[0]);
                        return parts.length > 1 && !Intrinsics.areEqual(parts[0], parts[1]) && (parts.length != 2 || !(((CharSequence)parts[1]).length() == 0));
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return false;
        }

        private final boolean isQuery(String value2, String match) {
            String string2 = value2.substring(StringsKt.indexOf$default((CharSequence)value2, match, 0, false, 6, null) + match.length());
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String followingString = string2;
            return StringsKt.startsWith$default(followingString, "=?", false, 2, null) || StringsKt.startsWith$default(followingString, "=%", false, 2, null) || StringsKt.startsWith$default(followingString, "=:", false, 2, null) || StringsKt.startsWith$default(followingString, "={", false, 2, null) || Intrinsics.areEqual(followingString, "='");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

