/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.K1only;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@K1only
@Rule(key="S899")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/sonarsource/kotlin/checks/IgnoredOperationStatusCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
public final class IgnoredOperationStatusCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit;

    public IgnoredOperationStatusCheck() {
        FunMatcherImpl[] funMatcherImplArray = new FunMatcherImpl[]{FunMatcherKt.FunMatcher$default("java.io.File", null, null, null, false, null, null, null, null, null, IgnoredOperationStatusCheck::functionsToVisit$lambda$0, 1022, null), FunMatcherKt.FunMatcher$default("java.util.Iterator", "hasNext", null, null, false, null, null, null, null, null, IgnoredOperationStatusCheck::functionsToVisit$lambda$1, 1020, null), FunMatcherKt.FunMatcher$default("kotlin.collections.Iterator", "hasNext", null, null, false, null, null, null, null, null, IgnoredOperationStatusCheck::functionsToVisit$lambda$2, 1020, null), FunMatcherKt.FunMatcher$default("kotlin.collections.MutableIterator", "hasNext", null, null, false, null, null, null, null, null, IgnoredOperationStatusCheck::functionsToVisit$lambda$3, 1020, null), FunMatcherKt.FunMatcher$default("java.util.Enumeration", "hasMoreElements", null, null, false, null, null, null, null, null, IgnoredOperationStatusCheck::functionsToVisit$lambda$4, 1020, null), FunMatcherKt.FunMatcher$default("java.util.concurrent.locks.Lock", "tryLock", null, null, false, null, null, null, null, null, null, 2044, null), FunMatcherKt.FunMatcher$default("java.util.concurrent.locks.Condition", "await", null, null, false, null, null, null, null, null, IgnoredOperationStatusCheck::functionsToVisit$lambda$5, 1020, null), FunMatcherKt.FunMatcher$default("java.util.concurrent.locks.Condition", null, null, null, false, null, null, null, null, null, IgnoredOperationStatusCheck::functionsToVisit$lambda$6, 1022, null), FunMatcherKt.FunMatcher$default("java.util.concurrent.CountDownLatch", "await", null, null, false, null, null, null, null, null, IgnoredOperationStatusCheck::functionsToVisit$lambda$7, 1020, null), FunMatcherKt.FunMatcher$default("java.util.concurrent.Semaphore", "tryAcquire", null, null, false, null, null, null, null, null, null, 2044, null), FunMatcherKt.FunMatcher$default("java.util.concurrent.BlockingQueue", null, null, null, false, null, null, null, null, null, IgnoredOperationStatusCheck::functionsToVisit$lambda$8, 1022, null)};
        this.functionsToVisit = CollectionsKt.listOf(funMatcherImplArray);
    }

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        block2: {
            Intrinsics.checkNotNullParameter(callExpression, "callExpression");
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
            if (!BindingContextUtilsKt.isUsedAsStatement(callExpression, kotlinFileContext.getBindingContext())) break block2;
            Object obj = resolvedCall2.getResultingDescriptor();
            if (obj != null) {
                Object resultingDescriptor = obj;
                boolean bl = false;
                Object object = resultingDescriptor.getReturnType();
                if (object == null || (object = ApiExtensionsKt.simpleName((KotlinType)object)) == null) {
                    object = "this method";
                }
                Object returnType = object;
                String message = "Do something with the \"" + (String)returnType + "\" value returned by \"" + resultingDescriptor.getName() + "\".";
                AbstractCheck abstractCheck = this;
                KtExpression ktExpression = callExpression.getCalleeExpression();
                Intrinsics.checkNotNull(ktExpression);
                AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)ktExpression, message, null, null, 12, null);
            }
        }
    }

    private static final Unit functionsToVisit$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"delete", "mkdir", "renameTo", "setReadOnly", "setLastModified", "setWritable", "setReadable", "setExecutable"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$1(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.withNoArguments();
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$2(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.withNoArguments();
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$3(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.withNoArguments();
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$4(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.withNoArguments();
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$5(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"kotlin.Long", "java.util.concurrent.TimeUnit"};
        $this$FunMatcher.withArguments(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$6(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"awaitNanos", "awaitUntil"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$7(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"kotlin.Long", "java.util.concurrent.TimeUnit"};
        $this$FunMatcher.withArguments(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$8(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"offer", "remove"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }
}

