/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.CommonConstantsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.frontend.K1only;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.frontend.KotlinFileContextKt;

@K1only
@Rule(key="S6310")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/sonarsource/kotlin/checks/InjectableDispatchersCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
public final class InjectableDispatchersCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit = CommonConstantsKt.getFUNS_ACCEPTING_DISPATCHERS();

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        BindingContext bindingContext = kotlinFileContext.getBindingContext();
        List<ResolvedValueArgument> arguments2 = resolvedCall2.getValueArgumentsByIndex();
        Collection collection = arguments2;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        ResolvedValueArgument resolvedValueArgument = arguments2.get(0);
        Object object = resolvedValueArgument instanceof ExpressionValueArgument ? (ExpressionValueArgument)resolvedValueArgument : null;
        if (object == null || (object = ((ExpressionValueArgument)object).getValueArgument()) == null || (object = object.getArgumentExpression()) == null) {
            return;
        }
        Object argExpr = object;
        KtExpression ktExpression = ApiExtensionsKt.predictRuntimeValueExpression$default((KtExpression)argExpr, bindingContext, null, 2, null);
        KtQualifiedExpression ktQualifiedExpression = ktExpression instanceof KtQualifiedExpression ? (KtQualifiedExpression)ktExpression : null;
        if (ktQualifiedExpression == null) {
            return;
        }
        KtQualifiedExpression argValueExpr = ktQualifiedExpression;
        DeclarationDescriptor declarationDescriptor = ApiExtensionsKt.resolveReferenceTarget(argValueExpr, bindingContext);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor argReference = declarationDescriptor;
        if (Intrinsics.areEqual(ApiExtensionsKt.scope(argReference), "kotlinx.coroutines.Dispatchers")) {
            List secondaries = argExpr != argValueExpr ? CollectionsKt.listOf(KotlinFileContextKt.secondaryOf(kotlinFileContext, argValueExpr, "Hard-coded dispatcher")) : CollectionsKt.emptyList();
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)argExpr, "Avoid hardcoded dispatchers.", secondaries, null, 8, null);
        }
    }
}

