/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.K1only;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.Message;
import org.sonarsource.kotlin.api.reporting.MessageKt;

@K1only
@Rule(key="S6611")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lorg/sonarsource/kotlin/checks/MapValuesShouldBeAccessedSafelyCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "issueMessage", "Lorg/sonarsource/kotlin/api/reporting/Message;", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "context", "checkSuperType", "", "arrayAccessExpression", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkIfSubtype", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nMapValuesShouldBeAccessedSafelyCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapValuesShouldBeAccessedSafelyCheck.kt\norg/sonarsource/kotlin/checks/MapValuesShouldBeAccessedSafelyCheck\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n125#2:83\n310#2,14:84\n229#2,2:98\n241#2:100\n328#2:101\n1863#3,2:102\n1755#3,3:104\n*S KotlinDebug\n*F\n+ 1 MapValuesShouldBeAccessedSafelyCheck.kt\norg/sonarsource/kotlin/checks/MapValuesShouldBeAccessedSafelyCheck\n*L\n52#1:83\n59#1:84,14\n59#1:98,2\n59#1:100\n59#1:101\n63#1:102,2\n73#1:104,3\n*E\n"})
public final class MapValuesShouldBeAccessedSafelyCheck
extends CallAbstractCheck {
    @NotNull
    private final Message issueMessage = MessageKt.message(MapValuesShouldBeAccessedSafelyCheck::issueMessage$lambda$0);
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit = CollectionsKt.listOf(FunMatcherKt.FunMatcher$default(null, "get", null, null, false, null, null, null, null, null, MapValuesShouldBeAccessedSafelyCheck::functionsToVisit$lambda$1, 1021, null));

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        PsiElement sibling;
        void $this$getParentOfType$iv;
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        PsiElement psiElement = callExpression;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        KtDotQualifiedExpression ktDotQualifiedExpression = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtDotQualifiedExpression.class, strict$iv);
        PsiElement psiElement2 = sibling = ktDotQualifiedExpression != null ? PsiUtilsKt.getNextSiblingIgnoringWhitespace$default(ktDotQualifiedExpression, false, 1, null) : null;
        if (sibling instanceof KtOperationReferenceExpression && Intrinsics.areEqual(((KtOperationReferenceExpression)sibling).getOperationSignTokenType(), KtTokens.EXCLEXCL)) {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement3 = callExpression.getParent().getParent();
            Intrinsics.checkNotNullExpressionValue(psiElement3, "getParent(...)");
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, psiElement3, this.issueMessage, null, null, 12, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClass(@NotNull KtClass klass, @NotNull KotlinFileContext context) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        void $this$collectDescendantsOfType$iv;
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(context, "context");
        PsiElement psiElement = klass;
        Function1<KtArrayAccessExpression, Boolean> predicate$iv = arg_0 -> MapValuesShouldBeAccessedSafelyCheck.visitClass$lambda$2(this, context, arg_0);
        boolean $i$f$collectDescendantsOfType = false;
        void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        void var9_11 = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var12_15 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = new Function1<KtArrayAccessExpression, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(PsiElement it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (((Boolean)this.$predicate.invoke(it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtArrayAccessExpression) {
                    this.$action.invoke(element);
                }
            }
        });
        List arrayAccessExpressions = (List)to$iv$iv$iv;
        Iterable $this$forEach$iv = arrayAccessExpressions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtArrayAccessExpression it = (KtArrayAccessExpression)element$iv;
            boolean bl = false;
            PsiElement sibling = PsiUtilsKt.getNextSiblingIgnoringWhitespace$default(it, false, 1, null);
            if (!(sibling instanceof KtOperationReferenceExpression) || !Intrinsics.areEqual(((KtOperationReferenceExpression)sibling).getOperationSignTokenType(), KtTokens.EXCLEXCL)) continue;
            AbstractCheck abstractCheck = this;
            PsiElement psiElement2 = it.getParent();
            Intrinsics.checkNotNullExpressionValue(psiElement2, "getParent(...)");
            AbstractCheck.reportIssue$default(abstractCheck, context, psiElement2, this.issueMessage, null, null, 12, null);
        }
    }

    private final boolean checkSuperType(KtArrayAccessExpression arrayAccessExpression, BindingContext bindingContext) {
        boolean bl;
        block5: {
            KotlinType kotlinType = ApiExtensionsKt.determineType(arrayAccessExpression.getArrayExpression(), bindingContext);
            if (kotlinType == null) {
                return false;
            }
            KotlinType type2 = kotlinType;
            if (this.checkIfSubtype(type2)) {
                return true;
            }
            Iterable $this$any$iv = TypeUtilsKt.supertypes(type2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!this.checkIfSubtype(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean checkIfSubtype(KotlinType type2) {
        return Intrinsics.areEqual(DescriptorUtilsKt.getKotlinTypeFqName(type2, false), "kotlin.collections.Map") || Intrinsics.areEqual(DescriptorUtilsKt.getKotlinTypeFqName(type2, false), "kotlin.collections.MutableMap");
    }

    private static final Unit issueMessage$lambda$0(Message $this$message) {
        Intrinsics.checkNotNullParameter($this$message, "$this$message");
        $this$message.code("Map");
        $this$message.unaryPlus(" values should be accessed safely. Using the non-null assertion operator here can throw a NullPointerException.");
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$1(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"kotlin.collections.Map", "kotlin.collections.MutableMap"};
        $this$FunMatcher.withDefiningSupertypes(stringArray);
        return Unit.INSTANCE;
    }

    private static final boolean visitClass$lambda$2(MapValuesShouldBeAccessedSafelyCheck this$0, KotlinFileContext $context, KtArrayAccessExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.checkSuperType(it, $context.getBindingContext());
    }
}

