/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.K1only;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.PseudoRandomCheckKt;

@K1only
@Rule(key="S2245")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/sonarsource/kotlin/checks/PseudoRandomCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
public final class PseudoRandomCheck
extends AbstractCheck {
    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2, @NotNull KotlinFileContext kotlinFileContext) {
        block5: {
            CallableDescriptor resultingDescriptor;
            KtExpression calleeExpression;
            block4: {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
                BindingContext bindingContext = kotlinFileContext.getBindingContext();
                KtExpression ktExpression = expression2.getCalleeExpression();
                if (ktExpression == null) {
                    return;
                }
                calleeExpression = ktExpression;
                if (PseudoRandomCheckKt.access$getMATH_RANDOM_MATCHER$p().matches(expression2, bindingContext) || PseudoRandomCheckKt.access$getKOTLIN_RANDOM_MATCHER$p().matches(expression2, bindingContext)) {
                    AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)calleeExpression, "Make sure that using this pseudorandom number generator is safe here.", null, null, 12, null);
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, bindingContext);
                CallableDescriptor callableDescriptor = resultingDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
                if (!(resultingDescriptor instanceof ConstructorDescriptor)) break block4;
                ClassDescriptor classDescriptor = ((ConstructorDescriptor)resultingDescriptor).getConstructedClass();
                Intrinsics.checkNotNullExpressionValue(classDescriptor, "getConstructedClass(...)");
                Object object = DescriptorUtilsKt.fqNameOrNull(classDescriptor);
                if (object == null || (object = ((FqName)object).asString()) == null) break block5;
                Object it = object;
                boolean bl = false;
                if (PseudoRandomCheckKt.access$getRANDOM_CONSTRUCTOR_TYPES$p().contains(it)) {
                    AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)calleeExpression, "Make sure that using this pseudorandom number generator is safe here.", null, null, 12, null);
                }
                break block5;
            }
            Object object = resultingDescriptor;
            if (object == null || (object = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)object)) == null || (object = ((FqName)object).asString()) == null || (object = StringsKt.substringBeforeLast$default((String)object, ".", null, 2, null)) == null) break block5;
            Object it = object;
            boolean bl = false;
            if (PseudoRandomCheckKt.access$getRANDOM_STATIC_TYPES$p().contains(it) && !PseudoRandomCheckKt.access$isChainedMethodInvocation(expression2)) {
                AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)calleeExpression, "Make sure that using this pseudorandom number generator is safe here.", null, null, 12, null);
            }
        }
    }
}

