/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.RedundantMethodsInDataClassesCheckKt;

@Rule(key="S6207")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/sonarsource/kotlin/checks/RedundantMethodsInDataClassesCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "issueMessage", "", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nRedundantMethodsInDataClassesCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantMethodsInDataClassesCheck.kt\norg/sonarsource/kotlin/checks/RedundantMethodsInDataClassesCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n1863#2,2:214\n*S KotlinDebug\n*F\n+ 1 RedundantMethodsInDataClassesCheck.kt\norg/sonarsource/kotlin/checks/RedundantMethodsInDataClassesCheck\n*L\n67#1:214,2\n*E\n"})
public final class RedundantMethodsInDataClassesCheck
extends AbstractCheck {
    @NotNull
    private final String issueMessage;

    public RedundantMethodsInDataClassesCheck() {
        this.issueMessage = "Remove this redundant method which is the same as a default one.";
    }

    @Override
    public void visitClass(@NotNull KtClass klass, @NotNull KotlinFileContext context) {
        block7: {
            KtNamedFunction it;
            Intrinsics.checkNotNullParameter(klass, "klass");
            Intrinsics.checkNotNullParameter(context, "context");
            if (!klass.isData()) {
                return;
            }
            KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
            Intrinsics.checkNotNull(ktPrimaryConstructor);
            List<KtParameter> klassParameters = ktPrimaryConstructor.getValueParameters();
            KtNamedFunction equalsMethod = null;
            KtNamedFunction hashCodeMethod = null;
            Object object = klass.getBody();
            if (object != null && (object = ((KtClassBody)object).getFunctions()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtNamedFunction it2 = (KtNamedFunction)element$iv;
                    boolean bl = false;
                    if (RedundantMethodsInDataClassesCheckKt.access$getEQUALS_MATCHER$p().matches(it2)) {
                        equalsMethod = it2;
                        continue;
                    }
                    if (!RedundantMethodsInDataClassesCheckKt.access$getHASHCODE_MATCHER$p().matches(it2)) continue;
                    hashCodeMethod = it2;
                }
            }
            KtNamedFunction ktNamedFunction = equalsMethod;
            if (ktNamedFunction != null) {
                it = ktNamedFunction;
                boolean bl = false;
                List<KtParameter> list = it.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
                if (RedundantMethodsInDataClassesCheckKt.access$equalsHasDefaultImpl(it, klassParameters, list, klass.getName())) {
                    AbstractCheck abstractCheck = this;
                    PsiElement psiElement = it.getNameIdentifier();
                    Intrinsics.checkNotNull(psiElement);
                    AbstractCheck.reportIssue$default(abstractCheck, context, psiElement, this.issueMessage, null, null, 12, null);
                }
            }
            KtNamedFunction ktNamedFunction2 = hashCodeMethod;
            if (ktNamedFunction2 == null) break block7;
            it = ktNamedFunction2;
            boolean bl = false;
            if (RedundantMethodsInDataClassesCheckKt.access$hashCodeHasDefaultImpl(it, klassParameters)) {
                AbstractCheck abstractCheck = this;
                PsiElement psiElement = it.getNameIdentifier();
                Intrinsics.checkNotNull(psiElement);
                AbstractCheck.reportIssue$default(abstractCheck, context, psiElement, this.issueMessage, null, null, 12, null);
            }
        }
    }
}

