/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.descriptors.DescriptorUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.K1only;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@K1only
@Rule(key="S6318")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/sonarsource/kotlin/checks/RedundantSuspendModifierCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nRedundantSuspendModifierCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantSuspendModifierCheck.kt\norg/sonarsource/kotlin/checks/RedundantSuspendModifierCheck\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,45:1\n277#2,10:46\n299#2:56\n*S KotlinDebug\n*F\n+ 1 RedundantSuspendModifierCheck.kt\norg/sonarsource/kotlin/checks/RedundantSuspendModifierCheck\n*L\n38#1:46,10\n38#1:56\n*E\n"})
public final class RedundantSuspendModifierCheck
extends AbstractCheck {
    /*
     * WARNING - void declaration
     */
    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(context, "context");
        PsiElement psiElement = ApiExtensionsKt.suspendModifier(function2);
        if (psiElement == null) {
            return;
        }
        PsiElement suspendModifier = psiElement;
        KtNamedFunction $this$visitNamedFunction_u24lambda_u241 = function2;
        boolean bl = false;
        if ($this$visitNamedFunction_u24lambda_u241.hasBody() && !ApiExtensionsKt.overrides($this$visitNamedFunction_u24lambda_u241)) {
            void $this$findDescendantOfType$iv;
            PsiElement psiElement2 = $this$visitNamedFunction_u24lambda_u241;
            Function1<KtNameReferenceExpression, Boolean> predicate$iv = arg_0 -> RedundantSuspendModifierCheck.visitNamedFunction$lambda$1$lambda$0(context, arg_0);
            boolean $i$f$findDescendantOfType = false;
            void $this$findDescendantOfType$iv$iv = $this$findDescendantOfType$iv;
            boolean $i$f$findDescendantOfType2 = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv);
            Ref.ObjectRef result$iv$iv = new Ref.ObjectRef();
            $this$findDescendantOfType$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Ref.ObjectRef $result;
                {
                    this.$predicate = $predicate;
                    this.$result = $result;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    if (element instanceof KtNameReferenceExpression && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                        this.$result.element = element;
                        this.stopWalking();
                        return;
                    }
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                }
            });
            Object object = (KtNameReferenceExpression)((PsiElement)result$iv$iv.element);
            if (object == null) {
                AbstractCheck.reportIssue$default((AbstractCheck)this, context, suspendModifier, "Remove this unnecessary \"suspend\" modifier.", null, null, 12, null);
                object = Unit.INSTANCE;
            }
        }
    }

    private static final boolean visitNamedFunction$lambda$1$lambda$0(KotlinFileContext $context, KtNameReferenceExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(it, $context.getBindingContext());
        return resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null ? DescriptorUtilsKt.isSuspend((CallableDescriptor)((Object)resolvedCall2)) : true;
    }
}

