/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.types.KotlinType;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.K1only;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@K1only
@Rule(key="S6516")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/sonarsource/kotlin/checks/SamConversionCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitObjectDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
public final class SamConversionCheck
extends AbstractCheck {
    @Override
    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        KtSuperTypeListEntry ktSuperTypeListEntry = CollectionsKt.singleOrNull(declaration.getSuperTypeListEntries());
        if (ktSuperTypeListEntry == null) {
            return;
        }
        KtSuperTypeListEntry superTypeEntry = ktSuperTypeListEntry;
        Object object = superTypeEntry.getTypeReference();
        if (object == null || (object = ApiExtensionsKt.getType((KtTypeReference)object, context.getBindingContext())) == null) {
            return;
        }
        Object superType = object;
        if (ApiExtensionsKt.isFunctionalInterface((KotlinType)superType) && ApiExtensionsKt.hasExactlyOneFunctionAndNoProperties(declaration)) {
            PsiElement psiElement = declaration.getDeclarationKeyword();
            Intrinsics.checkNotNull(psiElement);
            TextRange textRange = ApiExtensionsKt.merge(context, psiElement, superTypeEntry);
            AbstractCheck.reportIssue$default((AbstractCheck)this, context, textRange, "Replace explicit functional interface implementation with lambda expression.", null, null, 12, null);
        }
    }
}

