/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.frontend.K1only;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.ServerCertificateCheckKt;

@K1only
@Rule(key="S4830")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\n\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000f\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u0010\u001a\u00020\u0005*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/sonarsource/kotlin/checks/ServerCertificateCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "belongsToTrustManagerClass", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "callsCheckTrusted", "throwsCertificateExceptionWithoutCatching", "acceptRecursively", "Lcom/intellij/psi/PsiElement;", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "ThrowCatchVisitor", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nServerCertificateCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerCertificateCheck.kt\norg/sonarsource/kotlin/checks/ServerCertificateCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1755#2,3:118\n*S KotlinDebug\n*F\n+ 1 ServerCertificateCheck.kt\norg/sonarsource/kotlin/checks/ServerCertificateCheck\n*L\n63#1:118,3\n*E\n"})
public final class ServerCertificateCheck
extends AbstractCheck {
    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        BindingContext bindingContext = kotlinFileContext.component3();
        if (this.belongsToTrustManagerClass(function2, bindingContext) && !this.callsCheckTrusted(function2, bindingContext) && !this.throwsCertificateExceptionWithoutCatching(function2, bindingContext)) {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = function2.getNameIdentifier();
            if (psiElement == null) {
                psiElement = function2;
            }
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, psiElement, "Enable server certificate validation on this SSL/TLS connection.", null, null, 12, null);
        }
    }

    private final boolean belongsToTrustManagerClass(KtNamedFunction $this$belongsToTrustManagerClass, BindingContext bindingContext) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = ServerCertificateCheckKt.access$getFunMatchers$p();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FunMatcherImpl it = (FunMatcherImpl)element$iv;
                    boolean bl2 = false;
                    if (!it.matches($this$belongsToTrustManagerClass, bindingContext)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean callsCheckTrusted(KtNamedFunction $this$callsCheckTrusted, BindingContext bindingContext) {
        var visitor2 = new KtVisitorVoid(bindingContext){
            private boolean foundCheckTrustedCall;
            final /* synthetic */ BindingContext $bindingContext;
            {
                this.$bindingContext = $bindingContext;
            }

            /*
             * Unable to fully structure code
             */
            public void visitCallExpression(KtCallExpression expression) {
                block5: {
                    Intrinsics.checkNotNullParameter(expression, "expression");
                    v0 = this;
                    if (this.foundCheckTrustedCall) ** GOTO lbl-1000
                    var2_2 = ServerCertificateCheckKt.access$getFunMatchers$p();
                    var3_3 = this.$bindingContext;
                    var9_4 = v0;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v1 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (FunMatcherImpl)element$iv;
                            $i$a$-any-ServerCertificateCheck$callsCheckTrusted$visitor$1$visitCallExpression$1 = false;
                            if (!it.matches(expression, var3_3)) continue;
                            v1 = true;
                            break block5;
                        }
                        v1 = false;
                    }
                }
                var10_10 = v1;
                v0 = var9_4;
                if (var10_10) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                v0.foundCheckTrustedCall = v2;
            }

            public final boolean callsCheckTrusted() {
                return this.foundCheckTrustedCall;
            }
        };
        this.acceptRecursively($this$callsCheckTrusted, visitor2);
        return visitor2.callsCheckTrusted();
    }

    private final boolean throwsCertificateExceptionWithoutCatching(KtNamedFunction $this$throwsCertificateExceptionWithoutCatching, BindingContext bindingContext) {
        ThrowCatchVisitor visitor2 = new ThrowCatchVisitor(bindingContext);
        this.acceptRecursively($this$throwsCertificateExceptionWithoutCatching, visitor2);
        return visitor2.throwsCertificateExceptionWithoutCatching();
    }

    private final void acceptRecursively(PsiElement $this$acceptRecursively, KtVisitorVoid visitor2) {
        $this$acceptRecursively.accept(visitor2);
        for (PsiElement psiElement : $this$acceptRecursively.getChildren()) {
            Intrinsics.checkNotNull(psiElement);
            PsiElement child = psiElement;
            this.acceptRecursively(child, visitor2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/sonarsource/kotlin/checks/ServerCertificateCheck$ThrowCatchVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "throwFound", "", "catchFound", "visitThrowExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "visitCatchSection", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "throwsCertificateExceptionWithoutCatching", "sonar-kotlin-checks"})
    private static final class ThrowCatchVisitor
    extends KtVisitorVoid {
        @NotNull
        private final BindingContext bindingContext;
        private boolean throwFound;
        private boolean catchFound;

        public ThrowCatchVisitor(@NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
            this.bindingContext = bindingContext;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void visitThrowExpression(@NotNull KtThrowExpression expression) {
            Intrinsics.checkNotNullParameter(expression, "expression");
            if (this.throwFound) ** GOTO lbl-1000
            v0 = ApiExtensionsKt.determineType(expression.getThrownExpression(), this.bindingContext);
            if (Intrinsics.areEqual("java.security.cert.CertificateException", v0 != null ? DescriptorUtilsKt.getKotlinTypeFqName(v0, false) : null)) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            this.throwFound = v1;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void visitCatchSection(@NotNull KtCatchClause catchClause) {
            Intrinsics.checkNotNullParameter(catchClause, "catchClause");
            if (this.catchFound) ** GOTO lbl-1000
            v0 = ApiExtensionsKt.determineType((PsiElement)catchClause.getCatchParameter(), this.bindingContext);
            if (Intrinsics.areEqual("java.security.cert.CertificateException", v0 != null ? DescriptorUtilsKt.getKotlinTypeFqName(v0, false) : null)) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            this.catchFound = v1;
        }

        public final boolean throwsCertificateExceptionWithoutCatching() {
            return this.throwFound && !this.catchFound;
        }
    }
}

