/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.Message;
import org.sonarsource.kotlin.checks.SimplifiedPreconditionsCheckKt;

@Rule(key="S6532")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0014\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lorg/sonarsource/kotlin/checks/SimplifiedPreconditionsCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/lang/Iterable;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitThrowExpression", "throwExpression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "processException", "preconditionCall", "", "processExceptionForError", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nSimplifiedPreconditionsCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplifiedPreconditionsCheck.kt\norg/sonarsource/kotlin/checks/SimplifiedPreconditionsCheck\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n1#2:230\n*E\n"})
public final class SimplifiedPreconditionsCheck
extends CallAbstractCheck {
    @NotNull
    private final Iterable<FunMatcherImpl> functionsToVisit;

    public SimplifiedPreconditionsCheck() {
        FunMatcherImpl[] funMatcherImplArray = new FunMatcherImpl[]{FunMatcherKt.FunMatcher$default("kotlin", "check", null, null, false, null, null, null, null, null, SimplifiedPreconditionsCheck::functionsToVisit$lambda$0, 1020, null), FunMatcherKt.FunMatcher$default("kotlin", "require", null, null, false, null, null, null, null, null, SimplifiedPreconditionsCheck::functionsToVisit$lambda$1, 1020, null)};
        this.functionsToVisit = CollectionsKt.listOf(funMatcherImplArray);
    }

    @Override
    @NotNull
    public Iterable<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        List<KtValueArgument> list = callExpression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
        KtExpression conditionExpression = CollectionsKt.first(list).getArgumentExpression();
        KtSingleValueToken ktSingleValueToken = KtTokens.EXCLEQ;
        Intrinsics.checkNotNullExpressionValue(ktSingleValueToken, "EXCLEQ");
        if (SimplifiedPreconditionsCheckKt.access$isNullCheckCondition(conditionExpression, ktSingleValueToken)) {
            KtExpression ktExpression = callExpression.getCalleeExpression();
            Intrinsics.checkNotNull(ktExpression);
            KtExpression functionCall = ktExpression;
            Intrinsics.checkNotNull(conditionExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
            String nullCheckVariable = SimplifiedPreconditionsCheckKt.access$getNullCheckVariable((KtBinaryExpression)conditionExpression);
            String string2 = functionCall.getText();
            Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
            Intrinsics.checkNotNull(nullCheckVariable);
            String replaceCall = SimplifiedPreconditionsCheckKt.access$callNotNull(string2, nullCheckVariable);
            String string3 = functionCall.getText();
            Intrinsics.checkNotNullExpressionValue(string3, "getText(...)");
            Message message = SimplifiedPreconditionsCheckKt.access$buildReportMessage(string3, "function call", replaceCall);
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)functionCall, message, null, null, 12, null);
        }
    }

    @Override
    public void visitThrowExpression(@NotNull KtThrowExpression throwExpression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(throwExpression, "throwExpression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (SimplifiedPreconditionsCheckKt.access$matchesException(throwExpression, SimplifiedPreconditionsCheckKt.access$getILLEGAL_STATE_EXCEPTION_CONSTRUCTOR_MATCH$p())) {
            this.processException(throwExpression, kotlinFileContext, "check");
            this.processExceptionForError(throwExpression, kotlinFileContext);
        } else if (SimplifiedPreconditionsCheckKt.access$matchesException(throwExpression, SimplifiedPreconditionsCheckKt.access$getILLEGAL_ARGUMENT_EXCEPTION_CONSTRUCTOR_MATCH$p())) {
            this.processException(throwExpression, kotlinFileContext, "require");
        }
    }

    private final void processException(KtThrowExpression throwExpression, KotlinFileContext kotlinFileContext, String preconditionCall) {
        if (SimplifiedPreconditionsCheckKt.access$isOnlyStatementInThen(throwExpression)) {
            KtIfExpression ktIfExpression = SimplifiedPreconditionsCheckKt.access$findIfExpression(throwExpression);
            Intrinsics.checkNotNull(ktIfExpression);
            KtIfExpression ifExpression = ktIfExpression;
            String replaceCall = SimplifiedPreconditionsCheckKt.access$computeReplaceCallForIfExpression(ifExpression, preconditionCall);
            String it = SimplifiedPreconditionsCheckKt.access$getErrorMessage(throwExpression);
            boolean bl = false;
            String string2 = it;
            Object throwMessage = string2 == null ? "" : " { " + string2 + " }";
            Message message = SimplifiedPreconditionsCheckKt.access$buildReportMessage("if", "expression", replaceCall + (String)throwMessage);
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = ifExpression.getIfKeyword();
            Intrinsics.checkNotNullExpressionValue(psiElement, "getIfKeyword(...)");
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, psiElement, message, null, null, 12, null);
        }
    }

    private final void processExceptionForError(KtThrowExpression throwExpression, KotlinFileContext kotlinFileContext) {
        if (SimplifiedPreconditionsCheckKt.access$isOnlyStatementInElse(throwExpression) || SimplifiedPreconditionsCheckKt.access$isOnlyStatementInWhenEntry(throwExpression)) {
            String string2 = SimplifiedPreconditionsCheckKt.access$getErrorMessage(throwExpression);
            if (string2 == null) {
                string2 = "\"\"";
            }
            String throwMessage = string2;
            Message message = SimplifiedPreconditionsCheckKt.access$buildReportMessage("throw", "expression", "error(" + throwMessage + ")");
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)throwExpression, message, null, null, 12, null);
        }
    }

    private static final Unit functionsToVisit$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"kotlin.Boolean"};
        $this$FunMatcher.withArguments(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$1(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"kotlin.Boolean"};
        $this$FunMatcher.withArguments(stringArray);
        return Unit.INSTANCE;
    }
}

