/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.K1only;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.Message;
import org.sonarsource.kotlin.api.reporting.MessageKt;
import org.sonarsource.kotlin.checks.SimplifyFilteringBeforeTerminalOperationCheckKt;

@K1only
@Rule(key="S6527")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/sonarsource/kotlin/checks/SimplifyFilteringBeforeTerminalOperationCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nSimplifyFilteringBeforeTerminalOperationCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplifyFilteringBeforeTerminalOperationCheck.kt\norg/sonarsource/kotlin/checks/SimplifyFilteringBeforeTerminalOperationCheck\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
public final class SimplifyFilteringBeforeTerminalOperationCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit = CollectionsKt.listOf(FunMatcherKt.FunMatcher$default("kotlin.collections", null, null, null, false, null, null, null, null, null, SimplifyFilteringBeforeTerminalOperationCheck::functionsToVisit$lambda$0, 1022, null));

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        block1: {
            Call call2;
            Call call3;
            Call call4;
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter(callExpression, "callExpression");
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
            PsiElement it = callExpression.getParent();
            boolean bl = false;
            KtDotQualifiedExpression ktDotQualifiedExpression = it instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)it : null;
            if (ktDotQualifiedExpression == null || (ktExpression = ktDotQualifiedExpression.getReceiverExpression()) == null || (call4 = CallUtilKt.getCall(ktExpression, kotlinFileContext.getBindingContext())) == null) break block1;
            Call callBeforeTerminalOp = call3 = call4;
            boolean bl2 = false;
            Call call5 = call2 = SimplifyFilteringBeforeTerminalOperationCheckKt.access$getFILTER_MATCHER$p().matches(callBeforeTerminalOp, kotlinFileContext.getBindingContext()) ? call3 : null;
            if (call2 != null) {
                Call filterCallBeforeTerminalOp = call2;
                boolean bl3 = false;
                String filterCallText = filterCallBeforeTerminalOp.getCallElement().getText();
                String filterPredicateText = filterCallBeforeTerminalOp.getValueArguments().get(0).asElement().getText();
                String terminalOpCallText = callExpression.getText();
                KtExpression ktExpression2 = callExpression.getCalleeExpression();
                Intrinsics.checkNotNull(ktExpression2);
                String terminalOpWithPredicate = ktExpression2.getText() + " " + filterPredicateText;
                Message message = MessageKt.message(arg_0 -> SimplifyFilteringBeforeTerminalOperationCheck.visitFunctionCall$lambda$4$lambda$3(filterCallText, terminalOpCallText, terminalOpWithPredicate, arg_0));
                AbstractCheck abstractCheck = this;
                KtElement ktElement = filterCallBeforeTerminalOp.getCallElement();
                Intrinsics.checkNotNullExpressionValue(ktElement, "getCallElement(...)");
                AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)ktElement, message, null, null, 12, null);
            }
        }
    }

    private static final Unit functionsToVisit$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"any", "none", "count", "last", "lastOrNull", "first", "firstOrNull", "single", "singleOrNull"};
        $this$FunMatcher.withNames(stringArray);
        $this$FunMatcher.withNoArguments();
        return Unit.INSTANCE;
    }

    private static final Unit visitFunctionCall$lambda$4$lambda$3(String $filterCallText, String $terminalOpCallText, String $terminalOpWithPredicate, Message $this$message) {
        Intrinsics.checkNotNullParameter($this$message, "$this$message");
        $this$message.unaryPlus("Remove ");
        Intrinsics.checkNotNull($filterCallText);
        $this$message.code($filterCallText);
        $this$message.unaryPlus(" and replace ");
        Intrinsics.checkNotNull($terminalOpCallText);
        $this$message.code($terminalOpCallText);
        $this$message.unaryPlus(" with ");
        $this$message.code($terminalOpWithPredicate);
        $this$message.unaryPlus(".");
        return Unit.INSTANCE;
    }
}

