/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.frontend.K1only;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.SimplifySizeExpressionCheckKt;

@K1only
@Rule(key="S6529")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0017\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J2\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J*\u0010!\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\""}, d2={"Lorg/sonarsource/kotlin/checks/SimplifySizeExpressionCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "matchedFun", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitReferenceExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "checkSizeTest", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkIsEmptyTest", "isIsEmpty", "", "checkNullTestOrReportSize", "sizeTest", "Lcom/intellij/psi/PsiElement;", "useIsEmpty", "doReportSize", "sizeTestQualifier", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "checkNullTest", "sonar-kotlin-checks"})
public final class SimplifySizeExpressionCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit;

    public SimplifySizeExpressionCheck() {
        FunMatcherImpl[] funMatcherImplArray = new FunMatcherImpl[]{SimplifySizeExpressionCheckKt.access$getCountMatcher$p(), SimplifySizeExpressionCheckKt.access$isEmptyMatcher$p(), SimplifySizeExpressionCheckKt.access$isNotEmptyMatcher$p()};
        this.functionsToVisit = CollectionsKt.listOf(funMatcherImplArray);
    }

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull FunMatcherImpl matchedFun, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(matchedFun, "matchedFun");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (Intrinsics.areEqual(matchedFun, SimplifySizeExpressionCheckKt.access$getCountMatcher$p())) {
            this.checkSizeTest(callExpression, kotlinFileContext);
        } else {
            this.checkIsEmptyTest(callExpression, Intrinsics.areEqual(matchedFun, SimplifySizeExpressionCheckKt.access$isEmptyMatcher$p()), kotlinFileContext);
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull KtReferenceExpression expression2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (expression2 instanceof KtNameReferenceExpression && (SimplifySizeExpressionCheckKt.access$getSizeFieldMatcher$p().matches((KtNameReferenceExpression)expression2, kotlinFileContext.getBindingContext()) || SimplifySizeExpressionCheckKt.access$getLengthFieldMatcher$p().matches((KtNameReferenceExpression)expression2, kotlinFileContext.getBindingContext()))) {
            this.checkSizeTest(expression2, kotlinFileContext);
        }
    }

    private final void checkSizeTest(KtExpression expression2, KotlinFileContext kotlinFileContext) {
        block11: {
            PsiElement psiElement;
            boolean isSizeEquals;
            KtBinaryExpression sizeTest;
            block10: {
                boolean bl;
                Integer operationTokenId;
                Integer n;
                PsiElement psiElement2 = expression2.getParent();
                Intrinsics.checkNotNullExpressionValue(psiElement2, "getParent(...)");
                PsiElement psiElement3 = this.skipParentParentheses(SimplifySizeExpressionCheckKt.access$expandOptionalQualifier(psiElement2));
                KtBinaryExpression ktBinaryExpression = psiElement3 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement3 : null;
                if (ktBinaryExpression == null) {
                    return;
                }
                sizeTest = ktBinaryExpression;
                Integer n2 = n = (operationTokenId = SimplifySizeExpressionCheckKt.access$getOperationTokenId(sizeTest));
                int n3 = 71;
                if (n2 != null && n2 == n3) {
                    bl = true;
                } else {
                    Integer n4 = n;
                    n3 = 72;
                    if (n4 == null || n4 != n3) {
                        Integer n5 = n;
                        n3 = 64;
                        if (n5 == null || n5 != n3) {
                            Integer n6 = n;
                            n3 = 63;
                            if (n6 == null || n6 != n3) {
                                return;
                            }
                        }
                    }
                    bl = false;
                }
                isSizeEquals = bl;
                BindingContext bindingContext = kotlinFileContext.getBindingContext();
                Integer n7 = operationTokenId;
                n3 = 63;
                if ((n7 == null || n7 != n3) && SimplifySizeExpressionCheckKt.access$isIntZeroLiteral(sizeTest.getRight(), bindingContext)) break block10;
                Integer n8 = operationTokenId;
                n3 = 64;
                if (n8 != null && n8 == n3 || !SimplifySizeExpressionCheckKt.access$isIntZeroLiteral(sizeTest.getLeft(), bindingContext)) break block11;
            }
            this.checkNullTestOrReportSize(sizeTest, isSizeEquals, true, (psiElement = expression2.getParent()) instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement : null, kotlinFileContext);
        }
    }

    private final void checkIsEmptyTest(KtCallExpression expression2, boolean isIsEmpty, KotlinFileContext kotlinFileContext) {
        boolean bl;
        PsiElement psiElement = expression2.getParent();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getParent(...)");
        PsiElement psiElement2 = this.skipParentParentheses(SimplifySizeExpressionCheckKt.access$expandOptionalQualifier(psiElement));
        if (psiElement2 == null) {
            return;
        }
        PsiElement isEmptyTest = psiElement2;
        if (isEmptyTest instanceof KtPrefixExpression) {
            Integer operationTokenId;
            Integer n = operationTokenId = SimplifySizeExpressionCheckKt.access$getOperationTokenId((KtExpression)isEmptyTest);
            int n2 = 60;
            bl = n != null && n == n2;
        } else {
            PsiElement endExclusive = isEmptyTest;
            isEmptyTest = expression2;
            while (!Intrinsics.areEqual(isEmptyTest.getParent(), endExclusive)) {
                isEmptyTest = isEmptyTest.getParent();
            }
            bl = false;
        }
        boolean isNegated = bl;
        PsiElement psiElement3 = expression2.getParent();
        this.checkNullTestOrReportSize(isEmptyTest, isIsEmpty != isNegated, isNegated, psiElement3 instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement3 : null, kotlinFileContext);
    }

    private final void checkNullTestOrReportSize(PsiElement sizeTest, boolean useIsEmpty, boolean doReportSize, KtDotQualifiedExpression sizeTestQualifier, KotlinFileContext kotlinFileContext) {
        if (this.checkNullTest(sizeTest, useIsEmpty, sizeTestQualifier, kotlinFileContext) || !doReportSize) {
            return;
        }
        String replaceFunction = useIsEmpty ? "isEmpty()" : "isNotEmpty()";
        AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, sizeTest, "Replace collection size check with \"" + replaceFunction + "\"", null, null, 12, null);
    }

    private final boolean checkNullTest(PsiElement sizeTest, boolean useIsEmpty, KtDotQualifiedExpression sizeTestQualifier, KotlinFileContext kotlinFileContext) {
        boolean bl;
        boolean bl2;
        KtDotQualifiedExpression ktDotQualifiedExpression = sizeTestQualifier;
        KtExpression ktExpression = ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getReceiverExpression() : null;
        KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        if (ktNameReferenceExpression == null) {
            return false;
        }
        KtNameReferenceExpression sizeTestReceiver = ktNameReferenceExpression;
        Object object = this.skipParentParentheses(sizeTest.getParent());
        KtBinaryExpression ktBinaryExpression = object instanceof KtBinaryExpression ? (KtBinaryExpression)object : null;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression connectorExpression = ktBinaryExpression;
        Object object2 = object = SimplifySizeExpressionCheckKt.access$getOperationTokenId(connectorExpression);
        int n = 74;
        if (object2 != null && (Integer)object2 == n) {
            bl2 = false;
        } else {
            Object object3 = object;
            n = 76;
            if (object3 != null && (Integer)object3 == n) {
                bl2 = true;
            } else {
                return false;
            }
        }
        boolean isOrConnector = bl2;
        if (isOrConnector != useIsEmpty) {
            return false;
        }
        KtExpression ktExpression2 = connectorExpression.getLeft();
        Object object4 = ktExpression2 != null ? this.skipParentheses(ktExpression2) : null;
        KtBinaryExpression ktBinaryExpression2 = object4 instanceof KtBinaryExpression ? (KtBinaryExpression)object4 : null;
        if (ktBinaryExpression2 == null) {
            return false;
        }
        KtBinaryExpression nullTest = ktBinaryExpression2;
        Object object5 = object4 = SimplifySizeExpressionCheckKt.access$getOperationTokenId(nullTest);
        int n2 = 71;
        if (object5 != null && (Integer)object5 == n2) {
            bl = true;
        } else {
            Object object6 = object4;
            n2 = 72;
            if (object6 != null && (Integer)object6 == n2) {
                bl = false;
            } else {
                return false;
            }
        }
        boolean isEqualsNull = bl;
        if (isEqualsNull != useIsEmpty) {
            return false;
        }
        KtNameReferenceExpression ktNameReferenceExpression2 = SimplifySizeExpressionCheckKt.access$getNullTestReference(nullTest);
        if (!Intrinsics.areEqual(ktNameReferenceExpression2 != null ? ktNameReferenceExpression2.getReferencedName() : null, sizeTestReceiver.getReferencedName())) {
            return false;
        }
        String replaceFunction = useIsEmpty ? "isNullOrEmpty()" : "!isNullOrEmpty()";
        AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)connectorExpression, "Replace null check and collection size check with \"" + replaceFunction + "\"", null, null, 12, null);
        return true;
    }
}

