/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.StreamNotConsumedCheckKt;

@Rule(key="S3958")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/sonarsource/kotlin/checks/StreamNotConsumedCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "matchedFun", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nStreamNotConsumedCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamNotConsumedCheck.kt\norg/sonarsource/kotlin/checks/StreamNotConsumedCheck\n+ 2 KotlinFileVisitor.kt\norg/sonarsource/kotlin/api/visiting/KotlinFileVisitorKt\n*L\n1#1,85:1\n30#2:86\n*S KotlinDebug\n*F\n+ 1 StreamNotConsumedCheck.kt\norg/sonarsource/kotlin/checks/StreamNotConsumedCheck\n*L\n78#1:86\n*E\n"})
public final class StreamNotConsumedCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit;

    public StreamNotConsumedCheck() {
        FunMatcherImpl[] funMatcherImplArray = new FunMatcherImpl[]{StreamNotConsumedCheckKt.access$getSEQUENCE_MATCHER$p(), FunMatcherKt.FunMatcher$default(null, null, null, "kotlin.collections.List", false, null, null, null, null, null, StreamNotConsumedCheck::functionsToVisit$lambda$0, 1015, null), FunMatcherKt.FunMatcher$default("java.util.stream.Stream", null, null, null, false, null, null, null, null, null, StreamNotConsumedCheck::functionsToVisit$lambda$1, 1022, null), FunMatcherKt.FunMatcher$default("java.util.stream.IntStream", null, null, null, false, null, null, null, null, null, StreamNotConsumedCheck::functionsToVisit$lambda$2, 1022, null), FunMatcherKt.FunMatcher$default("java.util.stream.LongStream", null, null, null, false, null, null, null, null, null, StreamNotConsumedCheck::functionsToVisit$lambda$3, 1022, null), FunMatcherKt.FunMatcher$default("java.util.stream.DoubleStream", null, null, null, false, null, null, null, null, null, StreamNotConsumedCheck::functionsToVisit$lambda$4, 1022, null)};
        this.functionsToVisit = CollectionsKt.listOf(funMatcherImplArray);
    }

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull FunMatcherImpl matchedFun, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(matchedFun, "matchedFun");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$visitFunctionCall_u24lambda_u245 = kaSession;
        boolean bl = false;
        if (!$this$visitFunctionCall_u24lambda_u245.isUsedAsExpression(callExpression)) {
            String message = Intrinsics.areEqual(matchedFun, StreamNotConsumedCheckKt.access$getSEQUENCE_MATCHER$p()) ? "Refactor the code so this sequence pipeline is used." : "Refactor the code so this stream pipeline is used.";
            AbstractCheck abstractCheck = this;
            KtExpression ktExpression = callExpression.getCalleeExpression();
            Intrinsics.checkNotNull(ktExpression);
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)ktExpression, message, null, null, 12, null);
        }
    }

    private static final Unit functionsToVisit$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"parallelStream", "stream"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$1(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = StreamNotConsumedCheckKt.access$getCOMMON_STREAM_NON_TERM$p();
        $this$FunMatcher.withNames(Arrays.copyOf(stringArray, stringArray.length));
        stringArray = new String[]{"flatMapToDouble", "flatMapToInt", "flatMapToLong", "mapToDouble", "mapToInt", "mapToLong"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$2(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = StreamNotConsumedCheckKt.access$getCOMMON_PRIMITIVE_STREAM_NON_TERM$p();
        $this$FunMatcher.withNames(Arrays.copyOf(stringArray, stringArray.length));
        stringArray = new String[]{"asDoubleStream", "asLongStream", "mapToDouble", "mapToLong"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$3(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = StreamNotConsumedCheckKt.access$getCOMMON_PRIMITIVE_STREAM_NON_TERM$p();
        $this$FunMatcher.withNames(Arrays.copyOf(stringArray, stringArray.length));
        stringArray = new String[]{"asDoubleStream", "mapToDouble", "mapToInt"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$4(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = StreamNotConsumedCheckKt.access$getCOMMON_PRIMITIVE_STREAM_NON_TERM$p();
        $this$FunMatcher.withNames(Arrays.copyOf(stringArray, stringArray.length));
        stringArray = new String[]{"mapToInt", "mapToLong"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }
}

