/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.StrongCipherAlgorithmCheckKt;

@Rule(key="S5547")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/sonarsource/kotlin/checks/StrongCipherAlgorithmCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitCallExpression", "", "callExpr", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nStrongCipherAlgorithmCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StrongCipherAlgorithmCheck.kt\norg/sonarsource/kotlin/checks/StrongCipherAlgorithmCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1755#2,3:59\n*S KotlinDebug\n*F\n+ 1 StrongCipherAlgorithmCheck.kt\norg/sonarsource/kotlin/checks/StrongCipherAlgorithmCheck\n*L\n50#1:59,3\n*E\n"})
public final class StrongCipherAlgorithmCheck
extends AbstractCheck {
    @Override
    public void visitCallExpression(@NotNull KtCallExpression callExpr, @NotNull KotlinFileContext kotlinFileContext) {
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter(callExpr, "callExpr");
                Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
                if (!StrongCipherAlgorithmCheckKt.access$getNullCipherConstructorMatcher$p().matches(callExpr)) break block8;
                AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)callExpr, "Use a strong cipher algorithm.", null, null, 12, null);
                break block9;
            }
            if (!StrongCipherAlgorithmCheckKt.access$getCipherGetInstanceMatcher$p().matches(callExpr)) break block9;
            List<KtValueArgument> list = callExpr.getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
            KtValueArgument ktValueArgument = CollectionsKt.firstOrNull(list);
            if (ktValueArgument != null) {
                KtValueArgument arg = ktValueArgument;
                boolean bl = false;
                Object object = arg.getArgumentExpression();
                if (object != null && (object = ApiExtensionsKt.predictRuntimeStringValue((KtExpression)object)) != null) {
                    String string2 = ((String)object).toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
                    object = string2;
                    if (string2 != null) {
                        boolean bl2;
                        block7: {
                            Object candidateString = object;
                            boolean bl3 = false;
                            Iterable $this$any$iv = StrongCipherAlgorithmCheckKt.access$getWeakCiphers$p();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    String cipher = (String)element$iv;
                                    boolean bl4 = false;
                                    if (!(Intrinsics.areEqual(candidateString, cipher) || StringsKt.startsWith$default((String)candidateString, cipher + "/", false, 2, null))) continue;
                                    bl2 = true;
                                    break block7;
                                }
                                bl2 = false;
                            }
                        }
                        if (bl2) {
                            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)arg, "Use a strong cipher algorithm.", null, null, 12, null);
                        }
                    }
                }
            }
        }
    }
}

