/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtElement;
import org.sonarsource.kotlin.checks.ComparableTree;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ \u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a8\u0006\u000e"}, d2={"Lorg/sonarsource/kotlin/checks/SyntacticEquivalence;", "", "<init>", "()V", "areEquivalent", "", "first", "", "Lcom/intellij/psi/PsiElement;", "second", "findDuplicatedGroups", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "list", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nSyntacticEquivalence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyntacticEquivalence.kt\norg/sonarsource/kotlin/checks/SyntacticEquivalence\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,88:1\n1485#2:89\n1510#2,3:90\n1513#2,3:100\n774#2:103\n865#2,2:104\n381#3,7:93\n*S KotlinDebug\n*F\n+ 1 SyntacticEquivalence.kt\norg/sonarsource/kotlin/checks/SyntacticEquivalence\n*L\n50#1:89\n50#1:90,3\n50#1:100,3\n51#1:103\n51#1:104,2\n50#1:93,7\n*E\n"})
public final class SyntacticEquivalence {
    @NotNull
    public static final SyntacticEquivalence INSTANCE = new SyntacticEquivalence();

    private SyntacticEquivalence() {
    }

    private final boolean areEquivalent(Iterator<? extends PsiElement> first, Iterator<? extends PsiElement> second) {
        Iterator<? extends PsiElement> firstIterator = first;
        Iterator<? extends PsiElement> secondIterator = second;
        while (firstIterator.hasNext() && secondIterator.hasNext()) {
            PsiElement psiElement = firstIterator.next();
            Intrinsics.checkNotNullExpressionValue(psiElement, "next(...)");
            PsiElement psiElement2 = secondIterator.next();
            Intrinsics.checkNotNullExpressionValue(psiElement2, "next(...)");
            if (this.areEquivalent(psiElement, psiElement2)) continue;
            return false;
        }
        return !firstIterator.hasNext() && !secondIterator.hasNext();
    }

    public final boolean areEquivalent(@NotNull PsiElement first, @NotNull PsiElement second) {
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(second, "second");
        if (first == second) {
            return true;
        }
        if (!Intrinsics.areEqual(first.getClass(), second.getClass())) {
            return false;
        }
        PsiElement[] psiElementArray = first.getChildren();
        Intrinsics.checkNotNullExpressionValue(psiElementArray, "getChildren(...)");
        Iterator<PsiElement> leftChildrenIterator = SequencesKt.filter(ArraysKt.asSequence((Object[])psiElementArray), SyntacticEquivalence::areEquivalent$lambda$0).iterator();
        PsiElement[] psiElementArray2 = second.getChildren();
        Intrinsics.checkNotNullExpressionValue(psiElementArray2, "getChildren(...)");
        Iterator<PsiElement> rightChildrenIterator = SequencesKt.filter(ArraysKt.asSequence((Object[])psiElementArray2), SyntacticEquivalence::areEquivalent$lambda$1).iterator();
        if (!leftChildrenIterator.hasNext() && !rightChildrenIterator.hasNext()) {
            return Intrinsics.areEqual(first.getText(), second.getText());
        }
        return this.areEquivalent(leftChildrenIterator, rightChildrenIterator);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<KtElement>> findDuplicatedGroups(@NotNull List<? extends KtElement> list) {
        void $this$filterTo$iv$iv;
        Iterable $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, "list");
        Iterable $this$groupBy$iv = list;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            KtElement p0 = (KtElement)element$iv$iv;
            boolean $i$f$findDuplicatedGroups$stub_for_inlining = false;
            boolean bl = false;
            ComparableTree key$iv$iv = new ComparableTree(p0);
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = destination$iv$iv.values();
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            List group = (List)element$iv$iv;
            boolean bl = false;
            if (!(group.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean areEquivalent$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof KtElement;
    }

    private static final boolean areEquivalent$lambda$1(PsiElement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof KtElement;
    }
}

