/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Rule(key="S104")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/sonarsource/kotlin/checks/TooManyLinesOfCodeFileCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "max", "", "getMax", "()I", "setMax", "(I)V", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "Companion", "sonar-kotlin-checks"})
public final class TooManyLinesOfCodeFileCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="max", description="Maximum authorized lines of code in a file.", defaultValue="1000")
    private int max = 1000;
    public static final int DEFAULT_MAX = 1000;

    public final int getMax() {
        return this.max;
    }

    public final void setMax(int n) {
        this.max = n;
    }

    @Override
    public void visitKtFile(@NotNull KtFile file2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        int numberOfLinesOfCode2 = this.numberOfLinesOfCode(file2);
        if (numberOfLinesOfCode2 > this.max) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, null, "File has " + numberOfLinesOfCode2 + " lines, which is greater than " + this.max + " authorized. Split it into smaller files.", null, null, 12, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/sonarsource/kotlin/checks/TooManyLinesOfCodeFileCheck$Companion;", "", "<init>", "()V", "DEFAULT_MAX", "", "sonar-kotlin-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

